/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.plugin;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.util.PrettyPrinter;
import org.spongepowered.common.applaunch.config.common.CommonConfig;
import org.spongepowered.common.applaunch.config.common.ExploitCategory;
import org.spongepowered.common.applaunch.config.core.SpongeConfigs;

public class ExploitPlugin
implements IMixinConfigPlugin {
    private static final Map<String, Function<ExploitCategory, Boolean>> mixinEnabledMappings = ImmutableMap.builder().put((Object)"AssuredChangesMarkedDirty", exploitCategory -> exploitCategory.markChunksAsDirtyOnEntityListModification).put((Object)"ChunkLoadOnPositionSet", exploitCategory -> exploitCategory.loadChunkOnEntityPositionSet).put((Object)"ProcessChunkOnMove", exploitCategory -> exploitCategory.updateTrackedChunkOnEntityMove).put((Object)"org.spongepowered.common.mixin.exploit.item.WritableBookItem_LimitBookSize", exploitCategory -> true).put((Object)"PlayerVehiclesSyncPatch", exploitCategory -> exploitCategory.syncPlayerPositionsForVehicleMovement).build();

    public void onLoad(String mixinPackage) {
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        CommonConfig globalConfig = SpongeConfigs.getCommon().get();
        if (globalConfig.modules.exploits) {
            Function<ExploitCategory, Boolean> function = mixinEnabledMappings.get(mixinClassName);
            if (function == null) {
                new PrettyPrinter(50).add("Could not find function for exploit patch").centre().hr().add("Missing function for class: " + mixinClassName).trace();
                return false;
            }
            return function.apply(globalConfig.exploits);
        }
        return false;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }
}

