/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.plugin;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.util.PrettyPrinter;
import org.spongepowered.common.applaunch.config.common.CommonConfig;
import org.spongepowered.common.applaunch.config.common.OptimizationCategory;
import org.spongepowered.common.applaunch.config.core.SpongeConfigs;

public class OptimizationPlugin
implements IMixinConfigPlugin {
    private static final Map<String, Function<OptimizationCategory, Boolean>> mixinEnabledMappings = ImmutableMap.builder().put((Object)"org.spongepowered.common.mixin.optimization.SpongeImplHooksMixin_Item_Pre_Merge", optimizationCategory -> optimizationCategory.dropsPreMerge).put((Object)"org.spongepowered.common.mixin.optimization.mcp.block.BlockRedstoneWireMixin_Eigen", optimizationCategory -> optimizationCategory.eigenRedstone.enabled).put((Object)"org.spongepowered.common.accessor.block.BlockRedstoneWireAccessor_Eigen", optimizationCategory -> optimizationCategory.eigenRedstone.enabled).put((Object)"org.spongepowered.common.mixin.optimization.mcp.entity.passive.TameableEntity_Optimization_Owner", optimizationCategory -> optimizationCategory.cacheTameableOwners).put((Object)"org.spongepowered.common.mixin.optimization.mcp.entity.item.ItemFrameEntityMixin_Optimization_Map", optimizationCategory -> optimizationCategory.optimizeMaps).put((Object)"org.spongepowered.common.mixin.invalid.optimization.entity.EntityTrackerEntryMixin_MapOptimization", optimizationCategory -> optimizationCategory.optimizeMaps).put((Object)"org.spongepowered.common.mixin.optimization.mcp.item.ItemMapMixin_MapOptimization", optimizationCategory -> optimizationCategory.optimizeMaps).put((Object)"org.spongepowered.common.mixin.optimization.mcp.world.storage.MapDataMixin_MapOptimization", optimizationCategory -> optimizationCategory.optimizeMaps).put((Object)"org.spongepowered.common.mixin.optimization.mcp.world.storage.MapInfoMixin_MapOptimization", optimizationCategory -> optimizationCategory.optimizeMaps).put((Object)"org.spongepowered.common.mixin.optimization.mcp.server.MinecraftServerMixin_MapOptimization", optimizationCategory -> optimizationCategory.optimizeMaps).put((Object)"org.spongepowered.common.mixin.optimization.mcp.tileentity.TileEntityMixin_Optimization_Hopper", optimizationCategory -> optimizationCategory.optimizeHoppers).put((Object)"org.spongepowered.common.mixin.optimization.mcp.tileentity.HopperTileEntityMixin_Optimization_Hopper", optimizationCategory -> optimizationCategory.optimizeHoppers).put((Object)"org.spongepowered.common.mixin.optimization.mcp.entity.EntityMixin_UseActiveChunkForCollisions", optimizationCategory -> optimizationCategory.useActiveChunksForCollisions).put((Object)"org.spongepowered.common.mixin.optimization.mcp.world.WorldMixin_UseActiveChunkForCollisions", optimizationCategory -> optimizationCategory.useActiveChunksForCollisions).put((Object)"org.spongepowered.common.mixin.optimization.mcp.world.WorldServerMixin_UseActiveChunkForCollisions", optimizationCategory -> optimizationCategory.useActiveChunksForCollisions).put((Object)"org.spongepowered.common.mixin.optimization.mcp.tileentity.ChestTileEntityMixin_Optimization_TileEntity", optimizationCategory -> optimizationCategory.optimizeBlockEntityTicking).put((Object)"org.spongepowered.common.mixin.optimization.mcp.tileentity.EnderChestTileEntityMixin_Optimization_TileEntity", optimizationCategory -> optimizationCategory.optimizeBlockEntityTicking).put((Object)"org.spongepowered.common.mixin.optimization.mcp.block.LeavesBlockMixin_DisablePersistentScheduledUpdate", optimizationCategory -> optimizationCategory.disableScheduledUpdatesForPersistentLeafBlocks).build();

    public void onLoad(String mixinPackage) {
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        CommonConfig globalConfig = SpongeConfigs.getCommon().get();
        if (globalConfig.modules.optimizations) {
            Function<OptimizationCategory, Boolean> optimizationCategoryBooleanFunction = mixinEnabledMappings.get(mixinClassName);
            if (optimizationCategoryBooleanFunction == null) {
                new PrettyPrinter(50).add("Could not find function for optimization patch").centre().hr().add("Missing function for class: " + mixinClassName).trace();
                return false;
            }
            return optimizationCategoryBooleanFunction.apply(globalConfig.optimizations);
        }
        return false;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }
}

