/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.tracker;

import java.lang.ref.WeakReference;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.profile.GameProfile;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.common.SpongeServer;
import org.spongepowered.common.bridge.CreatorTrackedBridge;
import org.spongepowered.common.bridge.data.DataCompoundHolder;
import org.spongepowered.common.entity.PlayerTracker;
import org.spongepowered.common.profile.SpongeGameProfileManager;

@Mixin(value={Entity.class, TileEntity.class})
public abstract class CreatorTrackedMixin_Tracker
implements CreatorTrackedBridge {
    private @Nullable UUID tracker$creator;
    private @Nullable UUID tracker$notifier;
    private @Nullable WeakReference<User> tracker$creatorUser;
    private @Nullable WeakReference<User> tracker$notifierUser;

    @Override
    public Optional<UUID> tracked$getCreatorUUID() {
        return Optional.ofNullable(this.tracker$creator);
    }

    @Override
    public Optional<UUID> tracked$getNotifierUUID() {
        return Optional.ofNullable(this.tracker$notifier);
    }

    @Override
    public void tracked$setCreatorReference(@Nullable User creator) {
        this.tracker$creator = creator == null ? null : creator.getUniqueId();
        this.tracker$creatorUser = new WeakReference<User>(creator);
    }

    @Override
    public Optional<User> tracked$getCreatorReference() {
        User value;
        User user = value = this.tracker$creatorUser == null ? null : (User)this.tracker$creatorUser.get();
        if (value == null && this.tracker$creator != null) {
            Optional<User> user2 = this.tracked$getTrackedUser(PlayerTracker.Type.CREATOR);
            user2.ifPresent(creator -> {
                this.tracker$creatorUser = new WeakReference<User>((User)creator);
            });
            return user2;
        }
        return Optional.ofNullable(value);
    }

    @Override
    public void tracked$setNotifier(@Nullable User notifier) {
        this.tracker$notifierUser = new WeakReference<User>(notifier);
        this.tracker$notifier = notifier == null ? null : notifier.getUniqueId();
    }

    @Override
    public Optional<User> tracked$getNotifierReference() {
        User value;
        User user = value = this.tracker$notifierUser == null ? null : (User)this.tracker$notifierUser.get();
        if (value == null && this.tracker$creator != null) {
            Optional<User> user2 = this.tracked$getTrackedUser(PlayerTracker.Type.NOTIFIER);
            user2.ifPresent(creator -> {
                this.tracker$notifierUser = new WeakReference<User>((User)creator);
            });
            return user2;
        }
        return Optional.ofNullable(value);
    }

    @Override
    public Optional<User> tracked$getTrackedUser(PlayerTracker.Type nbtKey) {
        User user;
        UUID uuid = this.getTrackedUniqueId(nbtKey);
        if (uuid == null) {
            return Optional.empty();
        }
        ServerPlayer player = Sponge.getServer().getPlayer(uuid).orElse(null);
        User user2 = user = player == null ? null : player.getUser();
        if (user != null) {
            return Optional.of(user);
        }
        String username = ((SpongeServer)Sponge.getServer()).getUsernameCache().getLastKnownUsername(uuid);
        if (username != null) {
            return Sponge.getServer().getUserManager().get(GameProfile.of(uuid, username));
        }
        GameProfile profile = Sponge.getServer().getGameProfileManager().getCache().getById(uuid).orElse(null);
        if (profile != null) {
            return Sponge.getServer().getUserManager().get(profile);
        }
        ((SpongeGameProfileManager)Sponge.getServer().getGameProfileManager()).lookupUserAsync(uuid);
        return Optional.empty();
    }

    @Override
    public void tracked$setTrackedUUID(PlayerTracker.Type type, @Nullable UUID uuid) {
        if (PlayerTracker.Type.CREATOR == type) {
            this.tracker$creator = uuid;
        } else if (PlayerTracker.Type.NOTIFIER == type) {
            this.tracker$notifier = uuid;
        }
    }

    private @Nullable UUID getTrackedUniqueId(PlayerTracker.Type type) {
        CompoundNBT compound;
        if (this.tracker$creator != null && PlayerTracker.Type.CREATOR == type) {
            return this.tracker$creator;
        }
        if (this instanceof TameableEntity) {
            TameableEntity ownable = (TameableEntity)this;
            LivingEntity owner = ownable.func_70902_q();
            if (owner instanceof PlayerEntity) {
                this.tracked$setTrackedUUID(PlayerTracker.Type.CREATOR, owner.func_110124_au());
                return owner.func_110124_au();
            }
        } else if (this.tracker$notifier != null && PlayerTracker.Type.NOTIFIER == type) {
            return this.tracker$notifier;
        }
        if (!(compound = ((DataCompoundHolder)((Object)this)).data$getSpongeData()).func_74764_b(type.compoundKey)) {
            return null;
        }
        CompoundNBT creatorNbt = compound.func_74775_l(type.compoundKey);
        if (!creatorNbt.func_74764_b("UUIDMost") && !creatorNbt.func_74764_b("UUIDLeast")) {
            return null;
        }
        UUID uniqueId = creatorNbt.func_186857_a("UUID");
        if (PlayerTracker.Type.CREATOR == type) {
            this.tracker$creator = uniqueId;
        } else if (PlayerTracker.Type.NOTIFIER == type) {
            this.tracker$notifier = uniqueId;
        }
        return uniqueId;
    }
}

