/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.tracker.block;

import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.bridge.block.TrackedBlockBridge;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.context.transaction.EffectTransactor;
import org.spongepowered.common.util.ReflectionUtil;

@Mixin(value={Block.class})
public abstract class BlockMixin_Tracker
implements TrackedBlockBridge {
    private final boolean tracker$hasNeighborLogicOverridden = ReflectionUtil.isNeighborChangedDeclared(this.getClass());
    private static @Nullable EffectTransactor tracker$effectTransactorForDrops = null;

    @Override
    public boolean bridge$overridesNeighborNotificationLogic() {
        return this.tracker$hasNeighborLogicOverridden;
    }

    @Inject(method={"dropResources(Lnet/minecraft/block/BlockState;Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;)V", "dropResources(Lnet/minecraft/block/BlockState;Lnet/minecraft/world/IWorld;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/tileentity/TileEntity;)V", "dropResources(Lnet/minecraft/block/BlockState;Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/tileentity/TileEntity;Lnet/minecraft/entity/Entity;Lnet/minecraft/item/ItemStack;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private static void tracker$cancelOnBlockRestoration(CallbackInfo ci) {
        if (Thread.currentThread() == PhaseTracker.SERVER.getSidedThread() && PhaseTracker.SERVER.getPhaseContext().isRestoring()) {
            ci.cancel();
        }
    }

    @Inject(method={"dropResources(Lnet/minecraft/block/BlockState;Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;)V"}, at={@At(value="HEAD")})
    private static void tracker$captureBlockProposedToBeSpawningDrops(BlockState state, World worldIn, BlockPos pos, CallbackInfo ci) {
        PhaseTracker server = PhaseTracker.SERVER;
        if (server.getSidedThread() != Thread.currentThread()) {
            return;
        }
        PhaseContext<@NonNull ?> context = server.getPhaseContext();
        if (!context.recordsEntitySpawns()) {
            return;
        }
        tracker$effectTransactorForDrops = context.getTransactor().logBlockDrops(context, worldIn, pos, state, null);
    }

    @Inject(method={"dropResources(Lnet/minecraft/block/BlockState;Lnet/minecraft/world/IWorld;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/tileentity/TileEntity;)V"}, at={@At(value="HEAD")})
    private static void tracker$captureBlockProposedToBeSpawningDrops(BlockState state, IWorld worldIn, BlockPos pos, @Nullable TileEntity tileEntity, CallbackInfo ci) {
        if (!(worldIn instanceof World)) {
            return;
        }
        PhaseTracker server = PhaseTracker.SERVER;
        if (server.getSidedThread() != Thread.currentThread()) {
            return;
        }
        PhaseContext<@NonNull ?> context = server.getPhaseContext();
        if (!context.recordsEntitySpawns()) {
            return;
        }
        tracker$effectTransactorForDrops = context.getTransactor().logBlockDrops(context, (World)worldIn, pos, state, tileEntity);
    }

    @Inject(method={"dropResources(Lnet/minecraft/block/BlockState;Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/tileentity/TileEntity;Lnet/minecraft/entity/Entity;Lnet/minecraft/item/ItemStack;)V"}, at={@At(value="HEAD")})
    private static void tracker$captureBlockProposedToBeSpawningDrops(BlockState state, World worldIn, BlockPos pos, @Nullable TileEntity tileEntity, Entity entity, ItemStack itemStack, CallbackInfo ci) {
        PhaseTracker server = PhaseTracker.SERVER;
        if (server.getSidedThread() != Thread.currentThread()) {
            return;
        }
        PhaseContext<@NonNull ?> context = server.getPhaseContext();
        if (!context.recordsEntitySpawns()) {
            return;
        }
        tracker$effectTransactorForDrops = context.getTransactor().logBlockDrops(context, worldIn, pos, state, tileEntity);
    }

    @Inject(method={"dropResources(Lnet/minecraft/block/BlockState;Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;)V", "dropResources(Lnet/minecraft/block/BlockState;Lnet/minecraft/world/IWorld;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/tileentity/TileEntity;)V", "dropResources(Lnet/minecraft/block/BlockState;Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/tileentity/TileEntity;Lnet/minecraft/entity/Entity;Lnet/minecraft/item/ItemStack;)V"}, at={@At(value="TAIL")})
    private static void tracker$closeEffectIfCapturing(CallbackInfo ci) {
        PhaseTracker server = PhaseTracker.SERVER;
        if (server.getSidedThread() != Thread.currentThread()) {
            return;
        }
        PhaseContext<@NonNull ?> context = server.getPhaseContext();
        if (!context.recordsEntitySpawns()) {
            return;
        }
        context.getTransactor().completeBlockDrops(tracker$effectTransactorForDrops);
    }
}

