/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.tracker.entity;

import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.scoreboard.Team;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.bridge.TrackableBridge;
import org.spongepowered.common.bridge.entity.EntityTrackedBridge;
import org.spongepowered.common.bridge.world.WorldBridge;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.context.transaction.EffectTransactor;
import org.spongepowered.common.event.tracking.phase.tick.EntityTickContext;

@Mixin(value={Entity.class})
public abstract class EntityMixin_Tracker
implements TrackableBridge,
EntityTrackedBridge {
    @Shadow
    @Final
    private EntityType<?> field_200606_g;
    @Shadow
    public World field_70170_p;
    @Shadow
    public boolean field_70128_L;
    @Shadow
    private Vector3d field_233557_ao_;
    @Shadow
    public float field_70177_z;
    @Shadow
    public float field_70125_A;
    @Shadow
    @Final
    protected Random field_70146_Z;
    private boolean tracker$trackedInWorld = false;
    private @Nullable Cause tracker$destructCause;
    protected @MonotonicNonNull EffectTransactor tracker$dropsTransactor = null;

    @Shadow
    public abstract void shadow$func_70066_B();

    @Shadow
    protected abstract void shadow$func_70052_a(int var1, boolean var2);

    @Shadow
    public abstract @Nullable Team func_96124_cp();

    @Shadow
    public abstract void shadow$func_70107_b(double var1, double var3, double var5);

    @Shadow
    public abstract void shadow$func_213317_d(Vector3d var1);

    @Shadow
    public abstract void shadow$func_213293_j(double var1, double var3, double var5);

    @Shadow
    public abstract float func_70047_e();

    @Shadow
    public abstract UUID shadow$func_110124_au();

    @Shadow
    public abstract void shadow$func_213301_b(Pose var1);

    @Shadow
    protected abstract void shadow$func_226264_Z_();

    @Shadow
    public abstract double shadow$func_226280_cw_();

    @Shadow
    public abstract double shadow$func_226277_ct_();

    @Shadow
    public abstract double shadow$func_226281_cx_();

    @Inject(method={"spawnAtLocation(Lnet/minecraft/item/ItemStack;F)Lnet/minecraft/entity/item/ItemEntity;"}, at={@At(value="HEAD")})
    private void tracker$logEntityDropTransactionIfNecessary(ItemStack stack, float offsetY, CallbackInfoReturnable<ItemEntity> cir) {
        PhaseTracker instance = PhaseTracker.SERVER;
        if (!instance.onSidedThread()) {
            return;
        }
        if (((WorldBridge)this.field_70170_p).bridge$isFake()) {
            return;
        }
        PhaseContext<@NonNull ?> context = instance.getPhaseContext();
        if (!context.doesBlockEventTracking()) {
            return;
        }
        if (this.tracker$dropsTransactor == null) {
            this.tracker$dropsTransactor = context.getTransactor().ensureEntityDropTransactionEffect((Entity)this);
        }
    }

    @Inject(method={"remove()V"}, at={@At(value="RETURN")})
    private void tracker$ensureDropEffectCompleted(CallbackInfo ci) {
        PhaseTracker instance = PhaseTracker.SERVER;
        if (!instance.onSidedThread()) {
            return;
        }
        if (((WorldBridge)this.field_70170_p).bridge$isFake()) {
            return;
        }
        PhaseContext<@NonNull ?> context = instance.getPhaseContext();
        if (!context.doesBlockEventTracking()) {
            return;
        }
        if (this.tracker$dropsTransactor != null) {
            this.tracker$dropsTransactor.close();
        }
    }

    @Override
    public boolean bridge$isWorldTracked() {
        return this.tracker$trackedInWorld;
    }

    @Override
    public void bridge$setWorldTracked(boolean tracked) {
        this.tracker$trackedInWorld = tracked;
        if (!tracked && this.tracker$destructCause != null && ShouldFire.DESTRUCT_ENTITY_EVENT) {
            Audience originalChannel = Audience.empty();
            SpongeCommon.postEvent(SpongeEventFactory.createDestructEntityEvent(this.tracker$destructCause, originalChannel, Optional.of(originalChannel), (Component)Component.empty(), (Component)Component.empty(), (org.spongepowered.api.entity.Entity)((Object)this), false));
            this.tracker$destructCause = null;
        }
    }

    @Override
    public boolean bridge$shouldTick() {
        return true;
    }

    @Override
    public boolean bridge$allowsBlockBulkCaptures() {
        return ((TrackableBridge)this.field_200606_g).bridge$allowsBlockBulkCaptures();
    }

    @Override
    public void bridge$setAllowsBlockBulkCaptures(boolean allowsBlockBulkCaptures) {
        ((TrackableBridge)this.field_200606_g).bridge$setAllowsBlockBulkCaptures(allowsBlockBulkCaptures);
    }

    @Override
    public boolean bridge$allowsBlockEventCreation() {
        return ((TrackableBridge)this.field_200606_g).bridge$allowsBlockEventCreation();
    }

    @Override
    public void bridge$setAllowsBlockEventCreation(boolean allowsBlockEventCreation) {
        ((TrackableBridge)this.field_200606_g).bridge$setAllowsBlockEventCreation(allowsBlockEventCreation);
    }

    @Override
    public boolean bridge$allowsEntityBulkCaptures() {
        return ((TrackableBridge)this.field_200606_g).bridge$allowsEntityBulkCaptures();
    }

    @Override
    public void bridge$setAllowsEntityBulkCaptures(boolean allowsEntityBulkCaptures) {
        ((TrackableBridge)this.field_200606_g).bridge$setAllowsEntityBulkCaptures(allowsEntityBulkCaptures);
    }

    @Override
    public boolean bridge$allowsEntityEventCreation() {
        return ((TrackableBridge)this.field_200606_g).bridge$allowsEntityEventCreation();
    }

    @Override
    public void bridge$setAllowsEntityEventCreation(boolean allowsEntityEventCreation) {
        ((TrackableBridge)this.field_200606_g).bridge$setAllowsEntityEventCreation(allowsEntityEventCreation);
    }

    @Override
    public void bridge$refreshTrackerStates() {
        ((TrackableBridge)this.field_200606_g).bridge$refreshTrackerStates();
    }

    @Override
    public void populateFrameModifier(CauseStackManager.StackFrame frame, EntityTickContext context) {
    }
}

