/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.tracker.server.management;

import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.server.management.PlayerInteractionManager;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.GameType;
import net.minecraft.world.World;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.event.block.InteractBlockEvent;
import org.spongepowered.api.event.item.inventory.InteractItemEvent;
import org.spongepowered.api.util.Direction;
import org.spongepowered.api.util.Tristate;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.bridge.inventory.container.ContainerBridge;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.inventory.InventoryEventFactory;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.registry.provider.DirectionFacingProvider;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.math.vector.Vector3d;
import org.spongepowered.math.vector.Vector3i;

@Mixin(value={PlayerInteractionManager.class})
public abstract class PlayerInteractionManagerMixin_Tracker {
    @Shadow
    public ServerPlayerEntity field_73090_b;
    @Shadow
    public net.minecraft.world.server.ServerWorld field_73092_a;
    @Shadow
    private GameType field_73091_c;

    @Shadow
    public abstract boolean func_73083_d();

    @Inject(method={"useItem"}, cancellable=true, at={@At(value="INVOKE", target="Lnet/minecraft/item/ItemStack;getCount()I", ordinal=0)})
    public void impl$callInteractItemSecondary(ServerPlayerEntity player, World p_187250_2_, ItemStack stack, Hand hand, CallbackInfoReturnable<ActionResultType> cir) {
        InteractItemEvent.Secondary event = SpongeCommonEventFactory.callInteractItemEventSecondary((PlayerEntity)player, stack, hand);
        if (event.isCancelled()) {
            cir.setReturnValue((Object)ActionResultType.FAIL);
        }
    }

    @Overwrite
    public ActionResultType func_219441_a(ServerPlayerEntity playerIn, World worldIn, ItemStack stackIn, Hand handIn, BlockRayTraceResult blockRaytraceResultIn) {
        ActionResultType result;
        Direction direction;
        BlockPos blockpos = blockRaytraceResultIn.func_216350_a();
        BlockState blockstate = worldIn.func_180495_p(blockpos);
        BlockSnapshot snapshot = ((ServerWorld)worldIn).createSnapshot(VecHelper.toVector3i(blockpos));
        Vector3d hitVec = Vector3d.from((double)blockRaytraceResultIn.func_216350_a().func_177958_n(), (double)blockRaytraceResultIn.func_216350_a().func_177956_o(), (double)blockRaytraceResultIn.func_216350_a().func_177952_p());
        InteractBlockEvent.Secondary event = SpongeCommonEventFactory.callInteractBlockEventSecondary((PlayerEntity)playerIn, stackIn, hitVec, snapshot, direction = DirectionFacingProvider.INSTANCE.getKey(blockRaytraceResultIn.func_216354_b()).get(), handIn);
        if (event.isCancelled()) {
            return ActionResultType.FAIL;
        }
        Tristate useItem = event.getUseItemResult();
        Tristate useBlock = event.getUseBlockResult();
        if (this.field_73091_c == GameType.SPECTATOR) {
            INamedContainerProvider inamedcontainerprovider = blockstate.func_215699_b(worldIn, blockpos);
            if (inamedcontainerprovider != null) {
                playerIn.func_213829_a(inamedcontainerprovider);
                Vector3i pos = VecHelper.toVector3i(blockRaytraceResultIn.func_216350_a());
                ServerLocation location = ServerLocation.of((ServerWorld)worldIn, pos);
                try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
                    frame.pushCause(playerIn);
                    frame.addContext(EventContextKeys.BLOCK_HIT, ((ServerWorld)worldIn).createSnapshot(pos));
                    ((ContainerBridge)playerIn.field_71070_bA).bridge$setOpenLocation(location);
                    if (!InventoryEventFactory.callInteractContainerOpenEvent(playerIn)) {
                        ActionResultType actionResultType = ActionResultType.SUCCESS;
                        return actionResultType;
                    }
                }
                return ActionResultType.SUCCESS;
            }
            return ActionResultType.PASS;
        }
        boolean flag = !playerIn.func_184614_ca().func_190926_b() || !playerIn.func_184592_cb().func_190926_b();
        boolean flag1 = playerIn.func_226563_dT_() && flag;
        ItemStack copiedStack = stackIn.func_77946_l();
        if (useBlock != Tristate.FALSE && !flag1) {
            Container lastOpenContainer = playerIn.field_71070_bA;
            result = blockstate.func_227031_a_(worldIn, (PlayerEntity)playerIn, handIn, blockRaytraceResultIn);
            if (result.func_226246_a_() && lastOpenContainer != playerIn.field_71070_bA) {
                Vector3i pos = VecHelper.toVector3i(blockRaytraceResultIn.func_216350_a());
                ServerLocation location = ServerLocation.of((ServerWorld)worldIn, pos);
                try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
                    frame.pushCause(playerIn);
                    frame.addContext(EventContextKeys.BLOCK_HIT, ((ServerWorld)worldIn).createSnapshot(pos));
                    ((ContainerBridge)playerIn.field_71070_bA).bridge$setOpenLocation(location);
                    if (!InventoryEventFactory.callInteractContainerOpenEvent(playerIn)) {
                        ActionResultType actionResultType = ActionResultType.FAIL;
                        return actionResultType;
                    }
                }
            }
            if (result.func_226246_a_()) {
                CriteriaTriggers.field_232607_M_.func_226695_a_(playerIn, blockpos, copiedStack);
                return result;
            }
        }
        if (!stackIn.func_190926_b() && !playerIn.func_184811_cZ().func_185141_a(stackIn.func_77973_b())) {
            if (useItem == Tristate.FALSE) {
                return ActionResultType.PASS;
            }
            ItemUseContext itemusecontext = new ItemUseContext((PlayerEntity)playerIn, handIn, blockRaytraceResultIn);
            if (this.func_73083_d()) {
                int i = stackIn.func_190916_E();
                result = stackIn.func_196084_a(itemusecontext);
                stackIn.func_190920_e(i);
            } else {
                result = stackIn.func_196084_a(itemusecontext);
            }
            if (result.func_226246_a_()) {
                CriteriaTriggers.field_232607_M_.func_226695_a_(playerIn, blockpos, copiedStack);
            }
            return result;
        }
        return ActionResultType.PASS;
    }
}

