/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.tracker.world.chunk;

import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ITickList;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimerTickList;
import net.minecraft.world.chunk.ChunkSection;
import net.minecraft.world.server.ServerWorld;
import org.apache.logging.log4j.Level;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.event.entity.CollideEntityEvent;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.block.SpongeBlockSnapshot;
import org.spongepowered.common.bridge.block.BlockStateBridge;
import org.spongepowered.common.bridge.world.WorldBridge;
import org.spongepowered.common.bridge.world.chunk.ActiveChunkReferantBridge;
import org.spongepowered.common.bridge.world.chunk.TrackedChunkBridge;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhasePrinter;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.context.transaction.ChangeBlock;
import org.spongepowered.common.event.tracking.context.transaction.pipeline.ChunkPipeline;
import org.spongepowered.common.event.tracking.phase.generation.ChunkLoadContext;
import org.spongepowered.common.event.tracking.phase.generation.GenerationPhase;
import org.spongepowered.common.util.PrettyPrinter;
import org.spongepowered.common.world.BlockChange;
import org.spongepowered.common.world.SpongeBlockChangeFlag;

@Mixin(value={Chunk.class})
public abstract class ChunkMixin_Tracker
implements TrackedChunkBridge {
    @Shadow
    @Final
    public static ChunkSection field_186036_a;
    @Shadow
    @Final
    private ChunkSection[] field_76652_q;
    @Shadow
    @Final
    private World field_76637_e;
    private @MonotonicNonNull PhaseContext<@NonNull ?> tracker$postProcessContext = null;

    @Shadow
    public abstract @Nullable TileEntity shadow$func_177424_a(BlockPos var1, Chunk.CreateEntityType var2);

    @Shadow
    public abstract BlockState func_180495_p(BlockPos var1);

    @Inject(method={"setBlockState"}, at={@At(value="HEAD")}, cancellable=true)
    private void tracker$sanityCheckServerWorldSetBlockState(BlockPos pos, BlockState state, boolean isMoving, CallbackInfoReturnable<BlockState> cir) {
        if (!((WorldBridge)this.field_76637_e).bridge$isFake()) {
            new PrettyPrinter(80).add("Illegal Direct Chunk Access").hr().add(new IllegalAccessException("No one should be accessing Chunk.setBlock in a ServerWorld's environment")).log(PhaseTracker.LOGGER, Level.WARN);
            cir.setReturnValue(null);
        }
    }

    @Override
    public @NonNull ChunkPipeline bridge$createChunkPipeline(BlockPos pos, BlockState newState, BlockState currentState, SpongeBlockChangeFlag flag, int limit) {
        boolean isFake = ((WorldBridge)this.field_76637_e).bridge$isFake();
        if (isFake) {
            throw new IllegalStateException("Cannot call ChunkBridge.bridge$buildChunkPipeline in non-Server managed worlds");
        }
        int xPos = pos.func_177958_n() & 0xF;
        int yPos = pos.func_177956_o();
        int zPos = pos.func_177952_p() & 0xF;
        ChunkSection chunksection = this.field_76652_q[yPos >> 4];
        if (chunksection == field_186036_a) {
            if (newState.func_196958_f()) {
                return ChunkPipeline.nullReturn((Chunk)this, (ServerWorld)this.field_76637_e);
            }
            this.field_76652_q[yPos >> 4] = chunksection = new ChunkSection(yPos >> 4 << 4);
        }
        PhaseContext<@NonNull ?> context = PhaseTracker.getInstance().getPhaseContext();
        @Nullable TileEntity existing = this.shadow$func_177424_a(pos, Chunk.CreateEntityType.CHECK);
        WeakReference<ServerWorld> ref = new WeakReference<ServerWorld>((ServerWorld)this.field_76637_e);
        SpongeBlockSnapshot snapshot = TrackingUtil.createPooledSnapshot(currentState, pos, flag, limit, existing, () -> (ServerWorld)Objects.requireNonNull(ref.get(), "ServerWorld dereferenced"), Optional::empty, Optional::empty);
        Block newBlock = newState.func_177230_c();
        Block currentBlock = currentState.func_177230_c();
        ChangeBlock transaction = context.createTransaction(snapshot, newState, flag);
        snapshot.blockChange = context.associateBlockChangeWithSnapshot(newState, newBlock, currentState, snapshot, currentBlock);
        if (((BlockStateBridge)((Object)snapshot.getState())).bridge$hasTileEntity() && (snapshot.blockChange == BlockChange.BREAK || snapshot.blockChange == BlockChange.MODIFY)) {
            transaction.queuedRemoval = existing;
        }
        ChunkPipeline.Builder builder = ChunkPipeline.builder().kickOff(transaction).chunk((Chunk)this).chunkSection(chunksection).world((ServerWorld)this.field_76637_e);
        transaction.populateChunkEffects(builder);
        return builder.build();
    }

    @Inject(method={"addEntity"}, at={@At(value="RETURN")})
    private void tracker$SetActiveChunkOnEntityAdd(Entity entityIn, CallbackInfo ci) {
        ((ActiveChunkReferantBridge)entityIn).bridge$setActiveChunk(this);
    }

    @Inject(method={"removeEntity(Lnet/minecraft/entity/Entity;I)V"}, at={@At(value="RETURN")})
    private void tracker$ResetEntityActiveChunk(Entity entityIn, int index, CallbackInfo ci) {
        ((ActiveChunkReferantBridge)entityIn).bridge$setActiveChunk(null);
    }

    @Inject(method={"postProcessGeneration"}, at={@At(value="HEAD")})
    private void tracker$startChunkPostProcess(CallbackInfo ci) {
        if (this.tracker$postProcessContext != null) {
            PhasePrinter.printMessageWithCaughtException(PhaseTracker.SERVER, "Expected to not have a chunk post process", "Chunk Post Process has not completed!", GenerationPhase.State.CHUNK_LOADING, this.tracker$postProcessContext, (Throwable)new NullPointerException("spongecommon.ChunkMixin_Tracker:tracker$postProcessContext is Null"));
            this.tracker$postProcessContext.close();
        }
        this.tracker$postProcessContext = ((ChunkLoadContext)GenerationPhase.State.CHUNK_LOADING.createPhaseContext(PhaseTracker.SERVER).chunk((Chunk)this).world((ServerWorld)this.field_76637_e)).buildAndSwitch();
    }

    @Inject(method={"postProcessGeneration"}, at={@At(value="RETURN")})
    private void tracker$endChunkPostProcess(CallbackInfo ci) {
        if (this.tracker$postProcessContext == null) {
            PhasePrinter.printMessageWithCaughtException(PhaseTracker.getInstance(), "Expected to complete Chunk Post Process", "Chunk Post Process has a null PhaseContext", new NullPointerException("spongecommon.ChunkMixin_Tracker:tracker$postProcessContext is Null"));
        }
        this.tracker$postProcessContext.close();
        this.tracker$postProcessContext = null;
    }

    @Inject(method={"setBlockEntity(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/tileentity/TileEntity;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/tileentity/TileEntity;clearRemoved()V")})
    private void tracker$SetActiveChunkOnTileEntityAdd(BlockPos pos, TileEntity tileEntityIn, CallbackInfo ci) {
        ((ActiveChunkReferantBridge)tileEntityIn).bridge$setActiveChunk(this);
    }

    @Inject(method={"getEntities(Lnet/minecraft/entity/Entity;Lnet/minecraft/util/math/AxisAlignedBB;Ljava/util/List;Ljava/util/function/Predicate;)V"}, at={@At(value="RETURN")})
    private void tracker$ThrowCollisionEvent(Entity entityIn, AxisAlignedBB aabb, List<Entity> listToFill, Predicate<? super Entity> filter, CallbackInfo ci) {
        if (((WorldBridge)this.field_76637_e).bridge$isFake() || PhaseTracker.getInstance().getPhaseContext().isCollision()) {
            return;
        }
        if (listToFill.isEmpty()) {
            return;
        }
        if (!ShouldFire.COLLIDE_ENTITY_EVENT) {
            return;
        }
        CollideEntityEvent event = SpongeCommonEventFactory.callCollideEntityEvent(this.field_76637_e, entityIn, listToFill);
        if (event == null || event.isCancelled()) {
            if (event == null && !PhaseTracker.getInstance().getPhaseContext().isTicking()) {
                return;
            }
            listToFill.clear();
        }
    }

    @Redirect(method={"unpackTicks"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/chunk/ChunkPrimerTickList;copyOut(Lnet/minecraft/world/ITickList;Ljava/util/function/Function;)V"))
    private void tracker$wrapRescheduledTicks(ChunkPrimerTickList chunkPrimerTickList, ITickList<?> tickList, Function<BlockPos, ?> func) {
        if (!PhaseTracker.SERVER.onSidedThread()) {
            return;
        }
        try (ChunkLoadContext context = GenerationPhase.State.CHUNK_LOADING.createPhaseContext(PhaseTracker.SERVER);){
            context.chunk((Chunk)this);
            context.buildAndSwitch();
            chunkPrimerTickList.func_205381_a(tickList, func);
        }
    }
}

