/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.profile;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.authlib.Agent;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.ProfileLookupCallback;
import com.mojang.authlib.yggdrasil.ProfileNotFoundException;
import com.mojang.util.UUIDTypeAdapter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.core.util.Throwables;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.profile.GameProfileProvider;
import org.spongepowered.api.profile.property.ProfileProperty;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.profile.SpongeGameProfile;

public class UncachedGameProfileProvider
implements GameProfileProvider {
    private static final Gson GSON = new Gson();
    private final LoadingCache<UUID, CompletableFuture<@Nullable CachedProfile>> profileCache = Caffeine.newBuilder().expireAfterWrite(Duration.ofMinutes(1L)).build(this::requestProfile);
    private final Cache<String, @Nullable CachedProfile> profileByNameCache = Caffeine.newBuilder().expireAfterWrite(Duration.ofMinutes(1L)).build();

    private <T> CompletableFuture<T> submit(Callable<T> callable) {
        return SpongeCommon.getAsyncScheduler().submit(callable);
    }

    private void submit(Runnable runnable) {
        SpongeCommon.getAsyncScheduler().execute(runnable);
    }

    private CompletableFuture<@Nullable CachedProfile> requestProfile(UUID uniqueId) {
        return this.submit(() -> {
            GameProfile mcProfile = SpongeCommon.getServer().func_147130_as().fillProfileProperties(new GameProfile(uniqueId, ""), true);
            if (mcProfile == null) {
                return null;
            }
            CachedProfile cachedProfile = new CachedProfile(SpongeGameProfile.of(mcProfile));
            this.profileByNameCache.put((Object)mcProfile.getName().toLowerCase(Locale.ROOT), (Object)cachedProfile);
            return cachedProfile;
        });
    }

    @Override
    public CompletableFuture<org.spongepowered.api.profile.GameProfile> getProfile(UUID uniqueId, boolean signed) {
        Objects.requireNonNull(uniqueId, "uniqueId");
        return ((CompletableFuture)Objects.requireNonNull(this.profileCache.get((Object)uniqueId))).thenApply(profile -> {
            if (profile == null) {
                throw new org.spongepowered.api.profile.ProfileNotFoundException(uniqueId.toString());
            }
            return signed ? profile.getSigned() : profile.getUnsigned();
        });
    }

    @Override
    public CompletableFuture<org.spongepowered.api.profile.GameProfile> getProfile(String name, boolean signed) {
        Objects.requireNonNull(name, "name");
        CachedProfile cachedProfile = (CachedProfile)this.profileByNameCache.getIfPresent((Object)name.toLowerCase(Locale.ROOT));
        if (cachedProfile != null) {
            return CompletableFuture.completedFuture(signed ? cachedProfile.getSigned() : cachedProfile.getUnsigned());
        }
        return this.getBasicProfile(name).thenCompose(basicProfile -> this.getProfile(basicProfile.getUniqueId(), signed));
    }

    @Override
    public CompletableFuture<org.spongepowered.api.profile.GameProfile> getBasicProfile(UUID uniqueId) {
        Objects.requireNonNull(uniqueId, "uniqueId");
        return ((CompletableFuture)Objects.requireNonNull(this.profileCache.get((Object)uniqueId))).thenApply(profile -> {
            if (profile == null) {
                throw new org.spongepowered.api.profile.ProfileNotFoundException(uniqueId.toString());
            }
            return profile.getSigned().withoutProperties();
        });
    }

    @Override
    public CompletableFuture<org.spongepowered.api.profile.GameProfile> getBasicProfile(String name, @Nullable Instant time) {
        Objects.requireNonNull(name, "name");
        if (time != null) {
            return this.submit(() -> {
                org.spongepowered.api.profile.GameProfile profile;
                try {
                    profile = this.requestBasicProfileAt(name, time);
                }
                catch (Exception ex) {
                    Throwables.rethrow(ex);
                    return null;
                }
                if (profile == null) {
                    throw new org.spongepowered.api.profile.ProfileNotFoundException(name);
                }
                return profile;
            });
        }
        CompletableFuture<org.spongepowered.api.profile.GameProfile> result = new CompletableFuture<org.spongepowered.api.profile.GameProfile>();
        this.submit(() -> SpongeCommon.getServer().func_152359_aw().findProfilesByNames(new String[]{name}, Agent.MINECRAFT, (ProfileLookupCallback)new SingleProfileLookupCallback(result)));
        return result;
    }

    @Override
    public CompletableFuture<Map<String, org.spongepowered.api.profile.GameProfile>> getBasicProfiles(Iterable<String> names, @Nullable Instant time) {
        Objects.requireNonNull(names, "names");
        CompletableFuture<Map<String, org.spongepowered.api.profile.GameProfile>> result = new CompletableFuture<Map<String, org.spongepowered.api.profile.GameProfile>>();
        if (time != null) {
            this.submit(() -> {
                HashMap<String, org.spongepowered.api.profile.GameProfile> resultMap = new HashMap<String, org.spongepowered.api.profile.GameProfile>();
                for (String name : names) {
                    try {
                        org.spongepowered.api.profile.GameProfile profile = this.requestBasicProfileAt(name, time);
                        if (profile == null) continue;
                        resultMap.put(name, profile);
                    }
                    catch (Exception e) {
                        result.completeExceptionally(e);
                        return;
                    }
                }
                result.complete(resultMap);
            });
        }
        ArrayList nameList = Lists.newArrayList(names);
        String[] namesArray = nameList.toArray(new String[0]);
        this.submit(() -> SpongeCommon.getServer().func_152359_aw().findProfilesByNames(namesArray, Agent.MINECRAFT, (ProfileLookupCallback)new MapProfileLookupCallback(result, nameList)));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private @Nullable org.spongepowered.api.profile.GameProfile requestBasicProfileAt(String name, Instant time) throws Exception {
        URL url = new URL("https://api.mojang.com/user/profiles/minecraft/" + name + "?at=" + time.getEpochSecond());
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        connection.connect();
        try {
            int code = connection.getResponseCode();
            if (code == 200) {
                JsonObject json = GSON.fromJson((Reader)new InputStreamReader(connection.getInputStream()), JsonObject.class);
                org.spongepowered.api.profile.GameProfile gameProfile = this.parseGameProfile(json);
                return gameProfile;
            }
            if (code == 204) {
                org.spongepowered.api.profile.GameProfile gameProfile = null;
                return gameProfile;
            }
            this.handleError(connection);
            org.spongepowered.api.profile.GameProfile gameProfile = null;
            return gameProfile;
        }
        finally {
            IOUtils.closeQuietly((InputStream)connection.getInputStream());
        }
    }

    private void handleError(HttpURLConnection connection) throws IOException {
        int code = connection.getResponseCode();
        if (code == 404) {
            throw new IOException("Not found");
        }
        InputStream is = connection.getInputStream();
        if (is.available() > 0) {
            String errorMessage;
            JsonObject json = GSON.fromJson((Reader)new InputStreamReader(is), JsonObject.class);
            String error = json.has("error") ? json.get("error").getAsString() : null;
            String string = errorMessage = json.has("errorMessage") ? json.get("errorMessage").getAsString() : null;
            if (error != null) {
                if (error.equals("IllegalArgumentException")) {
                    throw new IOException(new IllegalArgumentException(errorMessage));
                }
                throw new IOException(error + ": " + errorMessage);
            }
        } else {
            throw new IOException("Error code: " + code);
        }
    }

    private org.spongepowered.api.profile.GameProfile parseGameProfile(JsonObject json) {
        UUID uniqueId = UUIDTypeAdapter.fromString((String)json.get("id").getAsString());
        String name = json.get("name").getAsString();
        JsonArray propertiesJson = json.getAsJsonArray("properties");
        ImmutableList.Builder properties = ImmutableList.builder();
        for (JsonElement propertyJson : propertiesJson) {
            JsonObject propertyObj = propertyJson.getAsJsonObject();
            String propertyName = propertyObj.get("name").getAsString();
            String value = propertyObj.get("value").getAsString();
            String signature = propertyObj.has("signature") ? propertyObj.get("signature").getAsString() : null;
            properties.add((Object)ProfileProperty.of(propertyName, value, signature));
        }
        return new SpongeGameProfile(uniqueId, name, (List<ProfileProperty>)properties.build());
    }

    private static final class MapProfileLookupCallback
    implements ProfileLookupCallback {
        private final CompletableFuture<Map<String, org.spongepowered.api.profile.GameProfile>> result;
        private final List<String> nameQueue;
        private Map<String, org.spongepowered.api.profile.GameProfile> resultMap = new HashMap<String, org.spongepowered.api.profile.GameProfile>();

        private MapProfileLookupCallback(CompletableFuture<Map<String, org.spongepowered.api.profile.GameProfile>> result, List<String> nameQueue) {
            this.result = result;
            this.nameQueue = nameQueue;
        }

        public void complete() {
            if (this.resultMap != null) {
                this.result.complete(this.resultMap);
            }
        }

        public void onProfileLookupSucceeded(GameProfile profile) {
            String originalName = null;
            while (originalName == null && !this.nameQueue.isEmpty()) {
                String name = this.nameQueue.remove(0);
                if (!name.equalsIgnoreCase(profile.getName())) continue;
                originalName = name;
            }
            if (originalName == null) {
                throw new IllegalStateException();
            }
            if (this.resultMap != null) {
                this.resultMap.put(originalName, SpongeGameProfile.of(profile));
            }
        }

        public void onProfileLookupFailed(GameProfile profile, Exception exception) {
            if (exception instanceof ProfileNotFoundException) {
                return;
            }
            this.resultMap = null;
            this.result.completeExceptionally(exception);
        }
    }

    private static final class SingleProfileLookupCallback
    implements ProfileLookupCallback {
        private final CompletableFuture<org.spongepowered.api.profile.GameProfile> result;

        private SingleProfileLookupCallback(CompletableFuture<org.spongepowered.api.profile.GameProfile> result) {
            this.result = result;
        }

        public void onProfileLookupSucceeded(GameProfile profile) {
            this.result.complete(SpongeGameProfile.of(profile));
        }

        public void onProfileLookupFailed(GameProfile profile, Exception exception) {
            if (exception instanceof ProfileNotFoundException) {
                this.result.completeExceptionally(new org.spongepowered.api.profile.ProfileNotFoundException(profile.getName(), exception.getCause()));
            } else {
                this.result.completeExceptionally(exception);
            }
        }
    }

    private static final class CachedProfile {
        private final org.spongepowered.api.profile.GameProfile signed;
        private volatile @Nullable org.spongepowered.api.profile.GameProfile unsigned;

        private CachedProfile(org.spongepowered.api.profile.GameProfile signed) {
            this.signed = signed;
        }

        public org.spongepowered.api.profile.GameProfile getSigned() {
            return this.signed;
        }

        public org.spongepowered.api.profile.GameProfile getUnsigned() {
            org.spongepowered.api.profile.GameProfile unsigned = this.unsigned;
            if (unsigned != null) {
                return unsigned;
            }
            this.unsigned = unsigned = SpongeGameProfile.unsignedOf(this.signed);
            return unsigned;
        }
    }
}

