/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry;

import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.spongepowered.api.Engine;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.registry.Registry;
import org.spongepowered.api.registry.RegistryHolder;
import org.spongepowered.api.registry.RegistryKey;
import org.spongepowered.api.registry.RegistryReference;
import org.spongepowered.api.registry.RegistryType;
import org.spongepowered.api.registry.ValueNotFoundException;
import org.spongepowered.api.world.World;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.registry.SpongeRegistryKey;
import org.spongepowered.common.util.EngineUtil;

public class SpongeRegistryReference<T>
extends SpongeRegistryKey<T>
implements RegistryReference<T> {
    public SpongeRegistryReference(RegistryKey<T> key) {
        super(Objects.requireNonNull(key, "key").registry(), key.location());
    }

    @Override
    public T get(RegistryHolder holder) {
        T found = this.getFromHolder(Objects.requireNonNull(holder, "holder"));
        if (found == null) {
            if (holder instanceof Engine) {
                found = this.getFromHolder(SpongeCommon.getGame().registries());
            } else if (holder instanceof World && (found = this.getFromHolder(EngineUtil.determineEngine().registries())) == null) {
                found = this.getFromHolder(SpongeCommon.getGame().registries());
            }
        }
        if (found == null) {
            throw new ValueNotFoundException(String.format("No value found for key '%s'", this.location()));
        }
        return found;
    }

    @Override
    public T get(RegistryHolder holder, Set<RegistryHolder> alternatives) {
        Objects.requireNonNull(holder, "holder");
        Objects.requireNonNull(alternatives, "alternatives");
        T found = this.getFromHolder(holder);
        if (found == null) {
            RegistryHolder alternative;
            Iterator<RegistryHolder> iterator = alternatives.iterator();
            while (iterator.hasNext() && (found = this.getFromHolder(alternative = iterator.next())) == null) {
            }
        }
        if (found == null) {
            throw new ValueNotFoundException(String.format("No value found for key '%s'", this.location()));
        }
        return found;
    }

    @Nullable
    private T getFromHolder(RegistryHolder holder) {
        Optional<Registry<Registry>> regOpt = holder.findRegistry(this.registry());
        return regOpt.flatMap(entries -> entries.findValue(this.location())).orElse(null);
    }

    public static final class FactoryImpl
    implements RegistryReference.Factory {
        @Override
        public <T> RegistryReference<T> referenced(RegistryHolder holder, RegistryType<T> registry, T value) {
            ResourceKey key = Objects.requireNonNull(holder, "holder").registry(Objects.requireNonNull(registry, "registry")).valueKey(Objects.requireNonNull(value, "value"));
            return new SpongeRegistryReference<T>(new SpongeRegistryKey<T>(registry, key));
        }
    }
}

