/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.relocate.co.aikar.util;

import java.util.AbstractMap;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class MRUMapCache<K, V>
extends AbstractMap<K, V> {
    final Map<K, V> backingMap;
    Object cacheKey;
    V cacheValue;

    public MRUMapCache(Map<K, V> backingMap) {
        this.backingMap = backingMap;
    }

    @Override
    public int size() {
        return this.backingMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.backingMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return key != null && key.equals(this.cacheKey) || this.backingMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return value != null && value == this.cacheValue || this.backingMap.containsValue(value);
    }

    @Override
    public V get(Object key) {
        if (this.cacheKey != null && this.cacheKey.equals(key)) {
            return this.cacheValue;
        }
        this.cacheKey = key;
        this.cacheValue = this.backingMap.get(key);
        return this.cacheValue;
    }

    @Override
    public V put(K key, V value) {
        this.cacheKey = key;
        this.cacheValue = this.backingMap.put(key, value);
        return this.cacheValue;
    }

    @Override
    public V remove(Object key) {
        if (key != null && key.equals(this.cacheKey)) {
            this.cacheKey = null;
        }
        return this.backingMap.remove(key);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m3) {
        this.backingMap.putAll(m3);
    }

    @Override
    public void clear() {
        this.cacheKey = null;
        this.cacheValue = null;
        this.backingMap.clear();
    }

    @Override
    public Set<K> keySet() {
        return this.backingMap.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.backingMap.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.backingMap.entrySet();
    }

    public static <K, V> Map<K, V> of(Map<K, V> map) {
        return new MRUMapCache<K, V>(map);
    }
}

