/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.scoreboard;

import java.util.Optional;
import java.util.function.Function;
import net.kyori.adventure.text.format.NamedTextColor;
import net.minecraft.util.text.TextFormatting;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.scoreboard.displayslot.DisplaySlot;
import org.spongepowered.common.adventure.SpongeAdventure;

public final class SpongeDisplaySlot
implements DisplaySlot {
    private final @Nullable TextFormatting formatting;
    private final @Nullable Function<TextFormatting, DisplaySlot> withColorFunction;
    private @Nullable NamedTextColor color;

    public SpongeDisplaySlot() {
        this(null, null);
    }

    public SpongeDisplaySlot(@Nullable TextFormatting color, @Nullable Function<TextFormatting, DisplaySlot> withColorFunction) {
        this.withColorFunction = withColorFunction;
        this.formatting = color;
    }

    @Override
    public DisplaySlot withTeamColor(@Nullable NamedTextColor color) {
        if (this.withColorFunction == null) {
            return this;
        }
        DisplaySlot slot = this.withColorFunction.apply(color == null ? TextFormatting.RESET : SpongeAdventure.asVanilla(color));
        return slot == null ? this : slot;
    }

    @Override
    public Optional<NamedTextColor> getTeamColor() {
        if (this.color == null) {
            this.color = SpongeAdventure.asAdventureNamed(this.formatting);
        }
        return Optional.ofNullable(this.color);
    }
}

