/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.service.server.whitelist;

import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.server.management.UserList;
import net.minecraft.server.management.UserListEntry;
import net.minecraft.server.management.WhiteList;
import net.minecraft.server.management.WhitelistEntry;
import org.spongepowered.api.profile.GameProfile;
import org.spongepowered.api.service.whitelist.WhitelistService;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.accessor.server.management.UserListAccessor;
import org.spongepowered.common.accessor.server.management.UserListEntryAccessor;
import org.spongepowered.common.profile.SpongeGameProfile;
import org.spongepowered.common.util.UserListUtil;

@Singleton
public final class SpongeWhitelistService
implements WhitelistService {
    @Override
    public Collection<GameProfile> getWhitelistedProfiles() {
        ArrayList<GameProfile> profiles = new ArrayList<GameProfile>();
        WhiteList list = SpongeCommon.getServer().func_184103_al().func_152599_k();
        for (WhitelistEntry entry : ((UserListAccessor)list).accessor$map().values()) {
            profiles.add(SpongeGameProfile.of((com.mojang.authlib.GameProfile)((UserListEntryAccessor)entry).accessor$user()));
        }
        return profiles;
    }

    @Override
    public boolean isWhitelisted(GameProfile profile) {
        UserListAccessor whitelist = (UserListAccessor)SpongeWhitelistService.getWhitelist();
        whitelist.invoker$removeExpired();
        return whitelist.accessor$map().containsKey(whitelist.invoker$getKeyForUser(SpongeGameProfile.toMcProfile(profile)));
    }

    @Override
    public boolean addProfile(GameProfile profile) {
        boolean wasWhitelisted = this.isWhitelisted(profile);
        UserListUtil.addEntry((UserList)SpongeWhitelistService.getWhitelist(), (UserListEntry)new WhitelistEntry(SpongeGameProfile.toMcProfile(profile)));
        return wasWhitelisted;
    }

    @Override
    public boolean removeProfile(GameProfile profile) {
        boolean wasWhitelisted = this.isWhitelisted(profile);
        UserListUtil.removeEntry((UserList)SpongeWhitelistService.getWhitelist(), profile);
        return wasWhitelisted;
    }

    private static WhiteList getWhitelist() {
        return SpongeCommon.getServer().func_184103_al().func_152599_k();
    }
}

