/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.entity.projectile.FireworkRocketEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.registry.SimpleRegistry;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.item.FireworkEffect;
import org.spongepowered.api.item.FireworkShape;
import org.spongepowered.api.item.ItemTypes;
import org.spongepowered.api.registry.RegistryTypes;
import org.spongepowered.api.util.Color;
import org.spongepowered.common.accessor.entity.projectile.FireworkRocketEntityAccessor;
import org.spongepowered.common.item.SpongeFireworkEffectBuilder;
import org.spongepowered.common.item.SpongeItemStackBuilder;
import org.spongepowered.common.util.NBTCollectors;
import org.spongepowered.common.util.NBTStreams;

public final class FireworkUtil {
    public static @Nullable FireworkEffect getStarEffect(ItemStack item) {
        Preconditions.checkArgument((item.func_77973_b() == Items.field_196153_dF ? 1 : 0) != 0, (Object)"Item is not a firework star!");
        @Nullable CompoundNBT tag = item.func_179543_a("Explosion");
        if (tag == null) {
            return null;
        }
        return FireworkUtil.fromCompound(tag);
    }

    public static FireworkEffect fromCompound(CompoundNBT compound) {
        SpongeFireworkEffectBuilder builder = new SpongeFireworkEffectBuilder();
        if (compound.func_74764_b("Flicker")) {
            builder.flicker(compound.func_74767_n("Flicker"));
        }
        if (compound.func_74764_b("Trail")) {
            builder.trail(compound.func_74767_n("Trail"));
        }
        if (compound.func_74764_b("Type")) {
            byte type = compound.func_74771_c("Type");
            SimpleRegistry registry = (SimpleRegistry)Sponge.getGame().registries().registry(RegistryTypes.FIREWORK_SHAPE);
            @Nullable FireworkShape shape = (FireworkShape)registry.func_148745_a((int)type);
            if (shape != null) {
                builder.shape(shape);
            }
        }
        if (compound.func_74764_b("Colors")) {
            int[] colorsRaw;
            ArrayList colors = Lists.newArrayList();
            for (int color : colorsRaw = compound.func_74759_k("Colors")) {
                colors.add(Color.ofRgb(color));
            }
            builder.colors((Iterable<Color>)colors);
        }
        if (compound.func_74764_b("FadeColors")) {
            int[] fadesRaw;
            ArrayList fades = Lists.newArrayList();
            for (int fade : fadesRaw = compound.func_74759_k("FadeColors")) {
                fades.add(Color.ofRgb(fade));
            }
            builder.fades((Iterable<Color>)fades);
        }
        return builder.build();
    }

    public static CompoundNBT toCompound(FireworkEffect effect) {
        SimpleRegistry registry = (SimpleRegistry)Sponge.getGame().registries().registry(RegistryTypes.FIREWORK_SHAPE);
        CompoundNBT tag = new CompoundNBT();
        tag.func_74757_a("Flicker", effect.flickers());
        tag.func_74757_a("Trail", effect.hasTrail());
        tag.func_74774_a("Type", (byte)registry.func_148757_b((Object)effect.getShape()));
        int[] colorsArray = effect.getColors().stream().mapToInt(Color::getRgb).toArray();
        tag.func_74783_a("Colors", colorsArray);
        int[] fadeArray = effect.getFadeColors().stream().mapToInt(Color::getRgb).toArray();
        tag.func_74783_a("FadeColors", fadeArray);
        return tag;
    }

    public static boolean setFireworkEffects(Object object, List<? extends FireworkEffect> effects) {
        if (effects.isEmpty()) {
            return FireworkUtil.removeFireworkEffects(object);
        }
        ItemStack item = FireworkUtil.getItem(object);
        if (item.func_190926_b()) {
            return false;
        }
        if (item.func_77973_b() == Items.field_196153_dF) {
            item.func_77983_a("Explosion", (INBT)FireworkUtil.toCompound(effects.get(0)));
            return true;
        }
        if (item.func_77973_b() == Items.field_196152_dE) {
            CompoundNBT fireworks = item.func_190925_c("Fireworks");
            fireworks.func_218657_a("Explosions", (INBT)effects.stream().map(FireworkUtil::toCompound).collect(NBTCollectors.toTagList()));
            return true;
        }
        return false;
    }

    public static Optional<List<FireworkEffect>> getFireworkEffects(Object object) {
        Object effects;
        ItemStack item = FireworkUtil.getItem(object);
        if (item.func_190926_b()) {
            return Optional.empty();
        }
        if (item.func_77973_b() == Items.field_196152_dE) {
            @Nullable CompoundNBT fireworks = item.func_179543_a("Fireworks");
            if (fireworks == null || !fireworks.func_74764_b("Explosions")) {
                return Optional.empty();
            }
            ListNBT effectCompounds = fireworks.func_150295_c("Explosions", 10);
            effects = NBTStreams.toCompounds((Iterable<INBT>)effectCompounds).map(FireworkUtil::fromCompound).collect(Collectors.toList());
        } else {
            @Nullable FireworkEffect effect = FireworkUtil.getStarEffect(item);
            if (effect == null) {
                return Optional.empty();
            }
            effects = ImmutableList.of((Object)effect);
        }
        return Optional.of(effects);
    }

    public static boolean removeFireworkEffects(Object object) {
        ItemStack item = FireworkUtil.getItem(object);
        if (item.func_190926_b()) {
            return false;
        }
        if (item.func_77973_b() == Items.field_196153_dF) {
            @Nullable CompoundNBT tag = item.func_77978_p();
            if (tag == null) {
                return true;
            }
            tag.func_82580_o("Explosion");
            return true;
        }
        if (item.func_77973_b() == Items.field_196152_dE) {
            CompoundNBT fireworks = item.func_190925_c("Fireworks");
            fireworks.func_82580_o("Explosions");
            return true;
        }
        return false;
    }

    public static ItemStack getItem(FireworkRocketEntity firework) {
        ItemStack item = (ItemStack)firework.func_184212_Q().func_187225_a(FireworkRocketEntityAccessor.accessor$DATA_ID_FIREWORKS_ITEM());
        if (item.func_190926_b()) {
            item = (ItemStack)new SpongeItemStackBuilder().itemType(ItemTypes.FIREWORK_ROCKET).build();
            firework.func_184212_Q().func_187227_b(FireworkRocketEntityAccessor.accessor$DATA_ID_FIREWORKS_ITEM(), (Object)item);
        }
        return item;
    }

    private static ItemStack getItem(Object object) {
        if (object instanceof ItemStack) {
            return (ItemStack)object;
        }
        if (object instanceof FireworkRocketEntity) {
            return FireworkUtil.getItem((FireworkRocketEntity)object);
        }
        return ItemStack.field_190927_a;
    }

    private FireworkUtil() {
    }
}

