/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.util.graph;

import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import org.spongepowered.common.util.graph.CyclicGraphException;
import org.spongepowered.common.util.graph.DirectedGraph;

public class TopologicalOrder {
    public static <T> List<T> createOrderedLoad(DirectedGraph<T> graph) {
        ArrayList orderedList = new ArrayList();
        while (graph.getNodeCount() != 0) {
            DirectedGraph.DataNode<T> next = null;
            for (DirectedGraph.DataNode<T> node : graph.getNodes()) {
                if (node.getEdgeCount() != 0) continue;
                next = node;
                break;
            }
            if (next == null) {
                TarjanCycleDetector detector = new TarjanCycleDetector(graph);
                List<DirectedGraph.DataNode<?>[]> cycles = detector.getCycles();
                StringBuilder msg = new StringBuilder();
                msg.append("Graph is cyclic! Cycles:\n");
                for (DirectedGraph.DataNode<?>[] cycle : cycles) {
                    msg.append("[");
                    for (DirectedGraph.DataNode<?> node : cycle) {
                        msg.append(node.getData().toString()).append(" ");
                    }
                    msg.append("]\n");
                }
                throw new CyclicGraphException(cycles, msg.toString());
            }
            orderedList.add(next.getData());
            graph.remove(next.getData());
        }
        return orderedList;
    }

    private static class TarjanCycleDetector {
        private DirectedGraph<?> graph;
        private int index = 0;
        private Deque<DirectedGraph.DataNode<?>> stack = new ArrayDeque();
        private Object2IntOpenHashMap<DirectedGraph.DataNode<?>> node_indices = new Object2IntOpenHashMap();
        private Object2IntOpenHashMap<DirectedGraph.DataNode<?>> lowlinks = new Object2IntOpenHashMap();
        private List<DirectedGraph.DataNode<?>[]> result = null;

        public TarjanCycleDetector(DirectedGraph<?> graph) {
            this.graph = graph;
        }

        public List<DirectedGraph.DataNode<?>[]> getCycles() {
            if (this.result != null) {
                return this.result;
            }
            this.result = new ArrayList<DirectedGraph.DataNode<?>[]>();
            for (DirectedGraph.DataNode<?> node : this.graph.getNodes()) {
                if (this.node_indices.containsKey(node)) continue;
                this.strongconnect(node);
            }
            return this.result;
        }

        private void strongconnect(DirectedGraph.DataNode<?> node) {
            this.node_indices.put(node, this.index);
            this.lowlinks.put(node, this.index);
            ++this.index;
            this.stack.push(node);
            for (DirectedGraph.DataNode<?> adj : node.getAdjacent()) {
                int lowlink;
                if (!this.node_indices.containsKey(adj)) {
                    this.strongconnect(adj);
                    lowlink = Math.min(this.lowlinks.getInt(node), this.lowlinks.getInt(adj));
                    this.lowlinks.put(node, lowlink);
                    continue;
                }
                if (!this.stack.contains(adj)) continue;
                lowlink = Math.min(this.lowlinks.getInt(node), this.node_indices.getInt(adj));
                this.lowlinks.put(node, lowlink);
            }
            if (this.lowlinks.getInt(node) == this.node_indices.getInt(node)) {
                DirectedGraph.DataNode<?> w;
                ArrayList cycle = new ArrayList();
                do {
                    w = this.stack.pop();
                    cycle.add(w);
                } while (w != node);
                this.result.add(cycle.toArray(new DirectedGraph.DataNode[cycle.size()]));
            }
        }
    }
}

