/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.util.raytrace;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.entity.living.Living;
import org.spongepowered.api.util.blockray.RayTrace;
import org.spongepowered.api.util.blockray.RayTraceResult;
import org.spongepowered.api.world.Locatable;
import org.spongepowered.api.world.LocatableBlock;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.math.vector.Vector3i;

public abstract class AbstractSpongeRayTrace<T extends Locatable>
implements RayTrace<T> {
    private final Predicate<T> defaultFilter;
    int limit = 30;
    @Nullable org.spongepowered.math.vector.Vector3d start;
    @Nullable org.spongepowered.math.vector.Vector3d direction;
    @Nullable org.spongepowered.math.vector.Vector3d end;
    @Nullable ResourceKey world;
    @Nullable Predicate<T> select;
    @Nullable Predicate<LocatableBlock> continueWhileBlock = null;
    @Nullable Predicate<org.spongepowered.api.entity.Entity> continueWhileEntity = null;
    @Nullable Predicate<ServerLocation> continueWhileLocation = null;

    AbstractSpongeRayTrace(Predicate<T> defaultFilter) {
        this.defaultFilter = defaultFilter;
        this.select = defaultFilter;
    }

    @Override
    public final @NonNull RayTrace<@NonNull T> world(@NonNull ServerWorld serverWorld) {
        this.world = serverWorld.getKey();
        return this;
    }

    @Override
    public @NonNull RayTrace<@NonNull T> sourceEyePosition(@NonNull Living entity) {
        this.sourcePosition((org.spongepowered.math.vector.Vector3d)entity.get(Keys.EYE_POSITION).orElseThrow(() -> new IllegalArgumentException("Entity does not have an eye position key")));
        return this.world((ServerWorld)entity.getServerLocation().getWorld());
    }

    @Override
    public final @NonNull RayTrace<@NonNull T> sourcePosition(@NonNull org.spongepowered.math.vector.Vector3d sourcePosition) {
        this.start = sourcePosition;
        return this;
    }

    @Override
    public RayTrace<@NonNull T> direction(@NonNull org.spongepowered.math.vector.Vector3d direction) {
        this.end = null;
        this.direction = direction.normalize();
        return this;
    }

    @Override
    public RayTrace<@NonNull T> limit(int distance) {
        if (distance < 1) {
            throw new IllegalArgumentException("distance limit must be positive");
        }
        this.limit = distance;
        return this;
    }

    @Override
    public final @NonNull RayTrace<@NonNull T> continueUntil(@NonNull org.spongepowered.math.vector.Vector3d endPosition) {
        this.end = endPosition;
        this.direction = null;
        return this;
    }

    @Override
    public @NonNull RayTrace<@NonNull T> continueWhileLocation(@NonNull Predicate<ServerLocation> continueWhileLocation) {
        this.continueWhileLocation = this.continueWhileLocation == null ? continueWhileLocation : this.continueWhileLocation.and(continueWhileLocation);
        return this;
    }

    @Override
    public @NonNull RayTrace<@NonNull T> continueWhileBlock(@NonNull Predicate<LocatableBlock> continueWhileBlock) {
        this.continueWhileBlock = this.continueWhileBlock == null ? continueWhileBlock : this.continueWhileBlock.and(continueWhileBlock);
        return this;
    }

    @Override
    public @NonNull RayTrace<@NonNull T> continueWhileEntity(@NonNull Predicate<org.spongepowered.api.entity.Entity> continueWhileEntity) {
        this.continueWhileEntity = this.continueWhileEntity == null ? continueWhileEntity : this.continueWhileEntity.and(continueWhileEntity);
        return this;
    }

    @Override
    public final @NonNull RayTrace<@NonNull T> select(@NonNull Predicate<T> filter) {
        this.select = this.select == this.defaultFilter ? filter : this.select.or(filter);
        return this;
    }

    @Override
    public Optional<RayTraceResult<@NonNull T>> execute() {
        this.setupEnd();
        org.spongepowered.math.vector.Vector3d directionWithLength = this.end.sub(this.start);
        double length = directionWithLength.length();
        org.spongepowered.math.vector.Vector3d direction = directionWithLength.normalize();
        if (direction.lengthSquared() == 0.0) {
            throw new IllegalStateException("The start and end must be two different vectors");
        }
        ServerWorld serverWorld = Sponge.getServer().getWorldManager().world(this.world).orElseThrow(() -> new IllegalStateException("World with key " + this.world.getFormatted() + " is not loaded!"));
        Vector3i currentBlock = this.initialBlock(direction);
        Vector3i steps = this.createSteps(direction);
        TData tData = this.createInitialTData(direction);
        org.spongepowered.math.vector.Vector3d currentLocation = new org.spongepowered.math.vector.Vector3d(this.start.getX(), this.start.getY(), this.start.getZ());
        boolean requiresEntityTracking = this.requiresEntityTracking();
        boolean requireAdvancement = true;
        while (requireAdvancement) {
            Vector3d vec3dend;
            org.spongepowered.math.vector.Vector3d nextLocation;
            Vector3d vec3dstart = VecHelper.toVanillaVector3d(currentLocation);
            if (this.continueWhileLocation != null && !this.continueWhileLocation.test(ServerLocation.of(serverWorld, currentBlock))) {
                return Optional.empty();
            }
            if (tData.getTotalTWithNextStep() > length) {
                requireAdvancement = false;
                nextLocation = this.end;
                vec3dend = VecHelper.toVanillaVector3d(this.end);
            } else {
                nextLocation = currentLocation.add(direction.getX() * tData.getNextStep(), direction.getY() * tData.getNextStep(), direction.getZ() * tData.getNextStep());
                vec3dend = VecHelper.toVanillaVector3d(nextLocation);
            }
            Optional<RayTraceResult<@NonNull T>> result = this.testSelectLocation(serverWorld, vec3dstart, vec3dend);
            if (result.isPresent() && !this.shouldCheckFailures()) {
                return result;
            }
            if (!this.shouldAdvanceThroughBlock(serverWorld, vec3dstart, vec3dend)) {
                return Optional.empty();
            }
            if (requiresEntityTracking && this.continueWhileEntity != null) {
                double resultDistance = result.isPresent() ? result.get().getHitPosition().distanceSquared(currentLocation) : Double.MAX_VALUE;
                AxisAlignedBB targetAABB = this.getBlockAABB(currentBlock);
                for (Entity entity : this.getFailingEntities(serverWorld, targetAABB)) {
                    Vector3d hitPosition;
                    double sqdist;
                    Optional vec3d = entity.func_174813_aQ().func_216365_b(vec3dstart, vec3dend);
                    if (!vec3d.isPresent() || !((sqdist = (hitPosition = (Vector3d)vec3d.get()).func_72436_e(vec3dstart)) < resultDistance)) continue;
                    return Optional.empty();
                }
            }
            if (result.isPresent()) {
                return result;
            }
            if (!requireAdvancement) continue;
            currentLocation = nextLocation;
            currentBlock = this.getNextBlock(currentBlock, tData, steps);
            tData = this.advance(tData, steps, direction);
        }
        return Optional.empty();
    }

    @Override
    public @NonNull RayTrace<@NonNull T> reset() {
        this.select = this.defaultFilter;
        this.world = null;
        this.start = null;
        this.end = null;
        this.continueWhileBlock = null;
        this.continueWhileEntity = null;
        this.continueWhileLocation = null;
        return this;
    }

    final Vector3i getNextBlock(Vector3i current, TData data, Vector3i steps) {
        return current.add(data.nextStepWillAdvanceX() ? steps.getX() : 0, data.nextStepWillAdvanceY() ? steps.getY() : 0, data.nextStepWillAdvanceZ() ? steps.getX() : 0);
    }

    final Vector3i createSteps(org.spongepowered.math.vector.Vector3d direction) {
        return new Vector3i(Math.signum(direction.getX()), Math.signum(direction.getY()), Math.signum(direction.getZ()));
    }

    final AxisAlignedBB getBlockAABB(Vector3i currentBlock) {
        return new AxisAlignedBB((double)currentBlock.getX(), (double)currentBlock.getY(), (double)currentBlock.getZ(), (double)(currentBlock.getX() + 1), (double)(currentBlock.getY() + 1), (double)(currentBlock.getZ() + 1));
    }

    private List<Entity> getFailingEntities(ServerWorld serverWorld, AxisAlignedBB targetAABB) {
        return ((World)serverWorld).func_175674_a((Entity)null, targetAABB, this.continueWhileEntity.negate());
    }

    boolean requiresEntityTracking() {
        return this.continueWhileEntity != null;
    }

    List<Entity> selectEntities(ServerWorld serverWorld, AxisAlignedBB targetAABB) {
        return Collections.emptyList();
    }

    abstract Optional<RayTraceResult<@NonNull T>> testSelectLocation(ServerWorld var1, Vector3d var2, Vector3d var3);

    final LocatableBlock getBlock(ServerWorld world, Vector3d in, Vector3d out) {
        Vector3i coord = new Vector3i(Math.min(in.field_72450_a, out.field_72450_a), Math.min(in.field_72448_b, out.field_72448_b), Math.min(in.field_72449_c, out.field_72449_c));
        return world.getLocatableBlock(coord);
    }

    private boolean shouldAdvanceThroughBlock(ServerWorld serverWorld, Vector3d location, Vector3d exitLocation) {
        if (this.continueWhileBlock == null) {
            return true;
        }
        return this.continueWhileBlock.test(this.getBlock(serverWorld, location, exitLocation));
    }

    boolean shouldCheckFailures() {
        return false;
    }

    final void setupEnd() {
        if (this.start == null) {
            throw new IllegalStateException("start cannot be null");
        }
        if (this.end == null && this.direction == null) {
            throw new IllegalStateException("end cannot be null");
        }
        if (this.world == null) {
            throw new IllegalStateException("world cannot be null");
        }
        if (this.select == null) {
            throw new IllegalStateException("select filter cannot be null");
        }
        if (this.direction != null) {
            this.continueUntil(this.start.add(this.direction.mul((float)this.limit)));
        }
    }

    final Vector3i initialBlock(org.spongepowered.math.vector.Vector3d direction) {
        return new Vector3i(this.start.getX() - (double)(direction.getX() < 0.0 && this.start.getX() == 0.0 ? 1 : 0), this.start.getY() - (double)(direction.getY() < 0.0 && this.start.getY() == 0.0 ? 1 : 0), this.start.getZ() - (double)(direction.getZ() < 0.0 && this.start.getZ() == 0.0 ? 1 : 0));
    }

    final TData createInitialTData(org.spongepowered.math.vector.Vector3d direction) {
        return new TData(0.0, this.getT(this.start.getX(), direction.getX(), this.end.getX()), this.getT(this.start.getY(), direction.getY(), this.end.getY()), this.getT(this.start.getZ(), direction.getZ(), this.end.getZ()));
    }

    final TData advance(TData data, Vector3i steps, org.spongepowered.math.vector.Vector3d direction) {
        double nextStep = data.getNextStep();
        return new TData(data.getTotalTWithNextStep(), data.nextStepWillAdvanceX() ? (double)steps.getX() / direction.getX() : data.gettToX() - nextStep, data.nextStepWillAdvanceY() ? (double)steps.getY() / direction.getY() : data.gettToY() - nextStep, data.nextStepWillAdvanceZ() ? (double)steps.getZ() / direction.getZ() : data.gettToZ() - nextStep);
    }

    private double getT(double start, double direction, double end) {
        if (direction > 0.0) {
            return (Math.min(end, Math.ceil(start)) - start) / direction;
        }
        if (direction < 0.0) {
            return (Math.max(end, Math.floor(start)) - start) / direction;
        }
        return Double.POSITIVE_INFINITY;
    }

    static final class TData {
        private final double totalT;
        private final double tToX;
        private final double tToY;
        private final double tToZ;
        private final double nextStep;

        TData(double totalT, double tToX, double tToY, double tToZ) {
            this.totalT = totalT;
            this.tToX = tToX;
            this.tToY = tToY;
            this.tToZ = tToZ;
            this.nextStep = Math.min(tToX, Math.min(tToY, tToZ));
        }

        public double getTotalT() {
            return this.totalT;
        }

        public double gettToX() {
            return this.tToX;
        }

        public double gettToY() {
            return this.tToY;
        }

        public double gettToZ() {
            return this.tToZ;
        }

        public boolean nextStepWillAdvanceX() {
            return this.tToX <= this.nextStep;
        }

        public boolean nextStepWillAdvanceY() {
            return this.tToY <= this.nextStep;
        }

        public boolean nextStepWillAdvanceZ() {
            return this.tToZ <= this.nextStep;
        }

        public double getNextStep() {
            return this.nextStep;
        }

        public double getTotalTWithNextStep() {
            return this.nextStep + this.totalT;
        }
    }
}

