/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.biome.provider;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.RegistryLookupCodec;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.OverworldBiomeProvider;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.common.accessor.world.biome.provider.BiomeProviderAccessor;
import org.spongepowered.common.accessor.world.biome.provider.OverworldBiomeProviderAccessor;

public final class SpongeLayeredBiomeProviderHelper {
    private static final Codec<SpongeDataSection> SPONGE_CODEC = RecordCodecBuilder.create(r -> r.group((App)Biome.field_242420_e.optionalFieldOf("biomes").forGetter(v -> Optional.of(v.biomes))).apply((Applicative)r, f1 -> new SpongeDataSection(f1.orElse(null))));
    public static final Codec<OverworldBiomeProvider> DIRECT_CODEC = RecordCodecBuilder.create(r -> r.group((App)Codec.LONG.fieldOf("seed").stable().forGetter(v -> ((OverworldBiomeProviderAccessor)v).accessor$seed()), (App)Codec.BOOL.optionalFieldOf("legacy_biome_init_layer", (Object)Boolean.FALSE, Lifecycle.stable()).forGetter(v -> ((OverworldBiomeProviderAccessor)v).accessor$legacyBiomeInitLayer()), (App)Codec.BOOL.fieldOf("large_biomes").orElse((Object)false).stable().forGetter(v -> ((OverworldBiomeProviderAccessor)v).accessor$largeBiomes()), (App)RegistryLookupCodec.func_244331_a((RegistryKey)Registry.field_239720_u_).forGetter(v -> ((OverworldBiomeProviderAccessor)v).accessor$biomes()), (App)SPONGE_CODEC.optionalFieldOf("#sponge").forGetter(v -> {
        List<Biome> biomes = ((BiomeProviderAccessor)v).accessor$possibleBiomes();
        ArrayList supplied = new ArrayList();
        biomes.forEach(biome -> supplied.add(() -> biome));
        return Optional.of(new SpongeDataSection(supplied));
    })).apply((Applicative)r, r.stable((f1, f2, f3, f4, f5) -> {
        OverworldBiomeProvider provider = new OverworldBiomeProvider(f1.longValue(), f2.booleanValue(), f3.booleanValue(), f4);
        f5.ifPresent(v -> {
            ArrayList<Biome> biomes = new ArrayList<Biome>();
            v.biomes.forEach(biome -> biomes.add((Biome)biome.get()));
            ((BiomeProviderAccessor)provider).accessor$possibleBiomes(biomes);
        });
        return provider;
    })));

    private static final class SpongeDataSection {
        public final List<Supplier<Biome>> biomes;

        private SpongeDataSection(@Nullable List<Supplier<Biome>> biomes) {
            this.biomes = biomes;
        }
    }
}

