/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.generation;

import java.util.Objects;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.DimensionSettings;
import net.minecraft.world.gen.FlatChunkGenerator;
import net.minecraft.world.gen.FlatGenerationSettings;
import net.minecraft.world.gen.NoiseChunkGenerator;
import net.minecraft.world.gen.settings.DimensionGeneratorSettings;
import org.spongepowered.api.world.biome.provider.BiomeProvider;
import org.spongepowered.api.world.generation.ChunkGenerator;
import org.spongepowered.api.world.generation.ConfigurableChunkGenerator;
import org.spongepowered.api.world.generation.config.FlatGeneratorConfig;
import org.spongepowered.api.world.generation.config.NoiseGeneratorConfig;
import org.spongepowered.common.accessor.world.DimensionTypeAccessor;
import org.spongepowered.common.server.BootstrapProperties;

public final class SpongeChunkGeneratorFactory
implements ChunkGenerator.Factory {
    @Override
    public <T extends FlatGeneratorConfig> ConfigurableChunkGenerator<T> flat(T config) {
        return (ConfigurableChunkGenerator)new FlatChunkGenerator((FlatGenerationSettings)config);
    }

    @Override
    public <T extends NoiseGeneratorConfig> ConfigurableChunkGenerator<T> noise(BiomeProvider provider, T config) {
        return (ConfigurableChunkGenerator)new NoiseChunkGenerator((net.minecraft.world.biome.provider.BiomeProvider)Objects.requireNonNull(provider, "provider"), BootstrapProperties.dimensionGeneratorSettings.func_236221_b_(), () -> (DimensionSettings)Objects.requireNonNull(config, "config"));
    }

    @Override
    public <T extends NoiseGeneratorConfig> ConfigurableChunkGenerator<T> noise(BiomeProvider provider, long seed, T config) {
        return (ConfigurableChunkGenerator)new NoiseChunkGenerator((net.minecraft.world.biome.provider.BiomeProvider)Objects.requireNonNull(provider, "provider"), seed, () -> (DimensionSettings)Objects.requireNonNull(config, "config"));
    }

    @Override
    public ConfigurableChunkGenerator<NoiseGeneratorConfig> overworld() {
        return (ConfigurableChunkGenerator)DimensionGeneratorSettings.func_242750_a((Registry)BootstrapProperties.registries.func_243612_b(Registry.field_239720_u_), (Registry)BootstrapProperties.registries.func_243612_b(Registry.field_243549_ar), (long)BootstrapProperties.dimensionGeneratorSettings.func_236221_b_());
    }

    @Override
    public ConfigurableChunkGenerator<NoiseGeneratorConfig> theNether() {
        return (ConfigurableChunkGenerator)DimensionTypeAccessor.invoker$defaultNetherGenerator((Registry<Biome>)BootstrapProperties.registries.func_243612_b(Registry.field_239720_u_), (Registry<DimensionSettings>)BootstrapProperties.registries.func_243612_b(Registry.field_243549_ar), BootstrapProperties.dimensionGeneratorSettings.func_236221_b_());
    }

    @Override
    public ConfigurableChunkGenerator<NoiseGeneratorConfig> theEnd() {
        return (ConfigurableChunkGenerator)DimensionTypeAccessor.invoker$defaultEndGenerator((Registry<Biome>)BootstrapProperties.registries.func_243612_b(Registry.field_239720_u_), (Registry<DimensionSettings>)BootstrapProperties.registries.func_243612_b(Registry.field_243549_ar), BootstrapProperties.dimensionGeneratorSettings.func_236221_b_());
    }
}

