/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.generation.config.structure;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;
import net.minecraft.world.gen.settings.StructureSpreadSettings;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.world.generation.config.structure.SeparatedStructureConfig;
import org.spongepowered.api.world.generation.config.structure.SpacedStructureConfig;
import org.spongepowered.api.world.generation.config.structure.StructureGenerationConfig;
import org.spongepowered.api.world.generation.structure.Structure;

public final class SpongeStructureGenerationConfigBuilder
implements StructureGenerationConfig.Builder {
    public @Nullable SpacedStructureConfig stronghold;
    public final Map<Structure, SeparatedStructureConfig> structures = new Object2ObjectOpenHashMap();

    @Override
    public StructureGenerationConfig.Builder stronghold(@Nullable SpacedStructureConfig config) {
        this.stronghold = config;
        return this;
    }

    @Override
    public StructureGenerationConfig.Builder addStructure(Structure structure, SeparatedStructureConfig config) {
        this.structures.put(Objects.requireNonNull(structure, "structure"), Objects.requireNonNull(config, "config"));
        return this;
    }

    @Override
    public StructureGenerationConfig.Builder addStructures(Map<Structure, SeparatedStructureConfig> structures) {
        this.structures.putAll(Objects.requireNonNull(structures, "structures"));
        return this;
    }

    @Override
    public StructureGenerationConfig.Builder removeStructure(Structure structure) {
        this.structures.remove(Objects.requireNonNull(structure, "structure"));
        return this;
    }

    @Override
    public StructureGenerationConfig.Builder reset() {
        this.stronghold = (SpacedStructureConfig)DimensionStructuresSettings.field_236192_c_;
        this.structures.clear();
        this.structures.putAll((Map)DimensionStructuresSettings.field_236191_b_);
        return this;
    }

    @Override
    public StructureGenerationConfig.Builder from(StructureGenerationConfig value) {
        this.stronghold = value.stronghold().orElse(null);
        this.structures.clear();
        this.structures.putAll(value.structures());
        return this;
    }

    public @NonNull StructureGenerationConfig build() {
        return (StructureGenerationConfig)new DimensionStructuresSettings(Optional.ofNullable((StructureSpreadSettings)this.stronghold), this.structures);
    }
}

