/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.portal;

import java.util.function.Function;
import net.minecraft.block.PortalInfo;
import net.minecraft.entity.Entity;
import net.minecraft.world.server.ServerWorld;
import org.spongepowered.api.event.cause.entity.MovementType;
import org.spongepowered.api.event.cause.entity.MovementTypes;
import org.spongepowered.api.world.portal.PortalType;
import org.spongepowered.api.world.portal.PortalTypes;
import org.spongepowered.common.accessor.entity.EntityAccessor;
import org.spongepowered.common.world.portal.PlatformTeleporter;
import org.spongepowered.math.vector.Vector3d;

public abstract class VanillaPortalPlatformTeleporter
implements PlatformTeleporter {
    public static VanillaPortalPlatformTeleporter getNetherInstance() {
        return Holder.NETHER_INSTANCE;
    }

    public static VanillaPortalPlatformTeleporter getEndInstance() {
        return Holder.END_INSTANCE;
    }

    private VanillaPortalPlatformTeleporter() {
    }

    @Override
    public PortalInfo getPortalInfo(Entity entity, ServerWorld currentWorld, ServerWorld targetWorld, Vector3d currentPosition) {
        return ((EntityAccessor)entity).invoker$findDimensionEntryPoint(targetWorld);
    }

    @Override
    public Entity performTeleport(Entity entity, ServerWorld currentWorld, ServerWorld targetWorld, float xRot, Function<Boolean, Entity> entityRepositioner) {
        return entityRepositioner.apply(true);
    }

    @Override
    public boolean isVanilla() {
        return true;
    }

    @Override
    public MovementType getMovementType() {
        return MovementTypes.PORTAL.get();
    }

    public static final class End
    extends VanillaPortalPlatformTeleporter {
        @Override
        public PortalType getPortalType() {
            return PortalTypes.END.get();
        }
    }

    public static final class Nether
    extends VanillaPortalPlatformTeleporter {
        @Override
        public PortalType getPortalType() {
            return PortalTypes.NETHER.get();
        }
    }

    static class Holder {
        static final VanillaPortalPlatformTeleporter NETHER_INSTANCE = new Nether();
        static final VanillaPortalPlatformTeleporter END_INSTANCE = new End();

        Holder() {
        }
    }
}

