/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.server;

import java.io.IOException;
import java.nio.file.Path;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.world.server.WorldManager;

public interface SpongeWorldManager
extends WorldManager {
    public Path getDefaultWorldDirectory();

    public Path getDimensionDataPackDirectory();

    public static RegistryKey<World> createRegistryKey(ResourceKey key) {
        return RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)((ResourceLocation)key));
    }

    public void unloadWorld0(ServerWorld var1) throws IOException;

    public void loadLevel();

    default public String getDirectoryName(ResourceKey key) {
        RegistryKey<World> registryKey = SpongeWorldManager.createRegistryKey(key);
        if (World.field_234918_g_.equals(registryKey)) {
            return "";
        }
        if (World.field_234919_h_.equals(registryKey)) {
            return "DIM-1";
        }
        if (World.field_234920_i_.equals(registryKey)) {
            return "DIM1";
        }
        return key.getValue();
    }

    default public boolean isVanillaWorld(ResourceKey key) {
        RegistryKey<World> registryKey = SpongeWorldManager.createRegistryKey(key);
        return World.field_234918_g_.equals(registryKey) || World.field_234919_h_.equals(registryKey) || World.field_234920_i_.equals(registryKey);
    }

    default public boolean isVanillaSubWorld(String directoryName) {
        return "DIM-1".equals(directoryName) || "DIM1".equals(directoryName);
    }

    default public boolean isDefaultWorld(ResourceKey key) {
        RegistryKey<World> registryKey = SpongeWorldManager.createRegistryKey(key);
        return World.field_234918_g_.equals(registryKey);
    }

    default public Path getDataPackFile(ResourceKey key) {
        return this.getDimensionDataPackDirectory().resolve(key.getNamespace()).resolve("dimension").resolve(key.getValue() + ".json");
    }
}

