/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.server;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.function.Supplier;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.RegistryKeyCodec;
import net.minecraft.world.DimensionType;
import net.minecraft.world.biome.ColumnFuzzedBiomeMagnifier;
import net.minecraft.world.biome.IBiomeMagnifier;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.datapack.DataPackType;
import org.spongepowered.api.datapack.DataPackTypes;
import org.spongepowered.api.util.MinecraftDayTime;
import org.spongepowered.api.world.WorldTypeEffect;
import org.spongepowered.api.world.WorldTypeEffects;
import org.spongepowered.api.world.WorldTypeTemplate;
import org.spongepowered.api.world.biome.BiomeSampler;
import org.spongepowered.api.world.biome.BiomeSamplers;
import org.spongepowered.common.AbstractResourceKeyed;
import org.spongepowered.common.accessor.world.DimensionTypeAccessor;
import org.spongepowered.common.registry.provider.BiomeSamplerProvider;
import org.spongepowered.common.registry.provider.DimensionEffectProvider;
import org.spongepowered.common.util.AbstractResourceKeyedBuilder;
import org.spongepowered.common.util.MissingImplementationException;
import org.spongepowered.common.util.SpongeMinecraftDayTime;

public final class SpongeWorldTypeTemplate
extends AbstractResourceKeyed
implements WorldTypeTemplate {
    public final WorldTypeEffect effect;
    public final BiomeSampler biomeSampler;
    public final @Nullable MinecraftDayTime fixedTime;
    public final ResourceKey infiniburn;
    public final boolean ultraWarm;
    public final boolean natural;
    public final boolean skylight;
    public final boolean ceiling;
    public final boolean piglinSafe;
    public final boolean bedWorks;
    public final boolean respawnAnchorWorks;
    public final boolean hasRaids;
    public final boolean createDragonFight;
    public final float ambientLight;
    public final int logicalHeight;
    public final double coordinateScale;
    private static final Codec<SpongeDataSection> SPONGE_CODEC = RecordCodecBuilder.create(r -> r.group((App)ResourceLocation.field_240908_a_.optionalFieldOf("biome_sampler", (Object)new ResourceLocation("sponge", "column_fuzzed")).forGetter(v -> ((SpongeDataSection)v).biomeSampler), (App)Codec.BOOL.optionalFieldOf("create_dragon_fight", (Object)Boolean.FALSE).forGetter(v -> ((SpongeDataSection)v).createDragonFight)).apply((Applicative)r, SpongeDataSection::new));
    public static final Codec<DimensionType> DIRECT_CODEC = RecordCodecBuilder.create(r -> r.group((App)Codec.LONG.optionalFieldOf("fixed_time").xmap(v -> v.map(OptionalLong::of).orElseGet(OptionalLong::empty), v -> v.isPresent() ? Optional.of(v.getAsLong()) : Optional.empty()).forGetter(v -> ((DimensionTypeAccessor)v).accessor$fixedTime()), (App)Codec.BOOL.fieldOf("has_skylight").forGetter(DimensionType::func_218272_d), (App)Codec.BOOL.fieldOf("has_ceiling").forGetter(DimensionType::func_236037_d_), (App)Codec.BOOL.fieldOf("ultrawarm").forGetter(DimensionType::func_236040_e_), (App)Codec.BOOL.fieldOf("natural").forGetter(DimensionType::func_236043_f_), (App)Codec.doubleRange((double)1.0E-5f, (double)3.0E7).fieldOf("coordinate_scale").forGetter(DimensionType::func_242724_f), (App)Codec.BOOL.fieldOf("piglin_safe").forGetter(DimensionType::func_241509_i_), (App)Codec.BOOL.fieldOf("bed_works").forGetter(DimensionType::func_241510_j_), (App)Codec.BOOL.fieldOf("respawn_anchor_works").forGetter(DimensionType::func_241511_k_), (App)Codec.BOOL.fieldOf("has_raids").forGetter(DimensionType::func_241512_l_), (App)Codec.intRange((int)0, (int)256).fieldOf("logical_height").forGetter(DimensionType::func_241513_m_), (App)ResourceLocation.field_240908_a_.fieldOf("infiniburn").forGetter(v -> ((ITag.INamedTag)v.func_241515_q_()).func_230234_a_()), (App)ResourceLocation.field_240908_a_.fieldOf("effects").orElse((Object)((ResourceLocation)WorldTypeEffects.OVERWORLD.getKey())).forGetter(v -> ((DimensionTypeAccessor)v).accessor$effectsLocation()), (App)Codec.FLOAT.fieldOf("ambient_light").forGetter(v -> Float.valueOf(((DimensionTypeAccessor)v).accessor$ambientLight())), (App)SPONGE_CODEC.optionalFieldOf("#sponge").forGetter(v -> Optional.of(new SpongeDataSection((ResourceLocation)BiomeSamplerProvider.INSTANCE.get((BiomeSampler)v.func_227176_e_()), v.func_236046_h_())))).apply((Applicative)r, (f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12, f13, f14, f15) -> {
        ColumnFuzzedBiomeMagnifier biomeMagnifier = f15.isPresent() ? (IBiomeMagnifier)BiomeSamplerProvider.INSTANCE.get((ResourceKey)((SpongeDataSection)f15.get()).biomeSampler) : ColumnFuzzedBiomeMagnifier.INSTANCE;
        boolean createDragonFight = f15.isPresent() && ((SpongeDataSection)f15.get()).createDragonFight;
        return DimensionTypeAccessor.invoker$new(f1, f2, f3, f4, f5, f6, createDragonFight, f7, f8, f9, f10, f11, (IBiomeMagnifier)biomeMagnifier, f12, f13, f14.floatValue());
    }));
    public static final Codec<Supplier<DimensionType>> CODEC = RegistryKeyCodec.func_241794_a_((RegistryKey)Registry.field_239698_ad_, DIRECT_CODEC);

    protected SpongeWorldTypeTemplate(BuilderImpl builder) {
        super(builder.key);
        this.effect = builder.effect;
        this.fixedTime = builder.fixedTime;
        this.infiniburn = builder.infiniburn;
        this.ultraWarm = builder.scorching;
        this.natural = builder.natural;
        this.skylight = builder.skylight;
        this.ceiling = builder.ceiling;
        this.piglinSafe = builder.piglinSafe;
        this.bedWorks = builder.bedsUsable;
        this.respawnAnchorWorks = builder.respawnAnchorsUsable;
        this.hasRaids = builder.hasRaids;
        this.ambientLight = builder.ambientLighting;
        this.logicalHeight = builder.logicalHeight;
        this.coordinateScale = builder.coordinateMultiplier;
        this.biomeSampler = builder.biomeSampler;
        this.createDragonFight = builder.createDragonFight;
    }

    public SpongeWorldTypeTemplate(ResourceKey key, DimensionType dimensionType) {
        super(key);
        OptionalLong fixedTime = ((DimensionTypeAccessor)dimensionType).accessor$fixedTime();
        this.fixedTime = fixedTime.isPresent() ? new SpongeMinecraftDayTime(fixedTime.getAsLong()) : null;
        this.skylight = dimensionType.func_218272_d();
        this.ceiling = dimensionType.func_236037_d_();
        this.ultraWarm = dimensionType.func_236040_e_();
        this.natural = dimensionType.func_236043_f_();
        this.coordinateScale = dimensionType.func_242724_f();
        this.piglinSafe = dimensionType.func_241509_i_();
        this.bedWorks = dimensionType.func_241510_j_();
        this.respawnAnchorWorks = dimensionType.func_241511_k_();
        this.hasRaids = dimensionType.func_241512_l_();
        this.logicalHeight = dimensionType.func_241513_m_();
        this.biomeSampler = (BiomeSampler)dimensionType.func_227176_e_();
        this.infiniburn = (ResourceKey)((ITag.INamedTag)dimensionType.func_241515_q_()).func_230234_a_();
        this.effect = DimensionEffectProvider.INSTANCE.get((ResourceKey)((DimensionTypeAccessor)dimensionType).accessor$effectsLocation());
        this.ambientLight = ((DimensionTypeAccessor)dimensionType).accessor$ambientLight();
        this.createDragonFight = dimensionType.func_236046_h_();
    }

    @Override
    public DataPackType type() {
        return DataPackTypes.WORLD_TYPE;
    }

    @Override
    public int getContentVersion() {
        return 0;
    }

    @Override
    public DataContainer toContainer() {
        throw new MissingImplementationException("SpongeWorldTypeTemplate", "toContainer");
    }

    @Override
    public WorldTypeEffect effect() {
        return this.effect;
    }

    @Override
    public BiomeSampler biomeSampler() {
        return this.biomeSampler;
    }

    @Override
    public boolean scorching() {
        return this.ultraWarm;
    }

    @Override
    public boolean natural() {
        return this.natural;
    }

    @Override
    public double coordinateMultiplier() {
        return this.coordinateScale;
    }

    @Override
    public boolean hasSkylight() {
        return this.skylight;
    }

    @Override
    public boolean hasCeiling() {
        return this.ceiling;
    }

    @Override
    public float ambientLighting() {
        return this.ambientLight;
    }

    @Override
    public Optional<MinecraftDayTime> fixedTime() {
        return Optional.ofNullable(this.fixedTime);
    }

    @Override
    public boolean piglinSafe() {
        return this.piglinSafe;
    }

    @Override
    public boolean bedsUsable() {
        return this.bedWorks;
    }

    @Override
    public boolean respawnAnchorsUsable() {
        return this.respawnAnchorWorks;
    }

    @Override
    public boolean hasRaids() {
        return this.hasRaids;
    }

    @Override
    public int logicalHeight() {
        return this.logicalHeight;
    }

    @Override
    public boolean createDragonFight() {
        return this.createDragonFight;
    }

    public static final class FactoryImpl
    implements WorldTypeTemplate.Factory {
        @Override
        public WorldTypeTemplate overworld() {
            return new SpongeWorldTypeTemplate(ResourceKey.minecraft("overworld"), DimensionTypeAccessor.accessor$DEFAULT_OVERWORLD());
        }

        @Override
        public WorldTypeTemplate overworldCaves() {
            return new SpongeWorldTypeTemplate(ResourceKey.minecraft("overworld_caves"), DimensionTypeAccessor.accessor$DEFAULT_OVERWORLD_CAVES());
        }

        @Override
        public WorldTypeTemplate theNether() {
            return new SpongeWorldTypeTemplate(ResourceKey.minecraft("the_nether"), DimensionTypeAccessor.accessor$DEFAULT_NETHER());
        }

        @Override
        public WorldTypeTemplate theEnd() {
            return new SpongeWorldTypeTemplate(ResourceKey.minecraft("the_end"), DimensionTypeAccessor.accessor$DEFAULT_END());
        }
    }

    public static final class BuilderImpl
    extends AbstractResourceKeyedBuilder<WorldTypeTemplate, WorldTypeTemplate.Builder>
    implements WorldTypeTemplate.Builder {
        protected @Nullable WorldTypeEffect effect;
        protected @Nullable MinecraftDayTime fixedTime;
        protected @Nullable BiomeSampler biomeSampler;
        protected @Nullable ResourceKey infiniburn;
        protected boolean scorching;
        protected boolean natural;
        protected boolean skylight;
        protected boolean ceiling;
        protected boolean piglinSafe;
        protected boolean bedsUsable;
        protected boolean respawnAnchorsUsable;
        protected boolean hasRaids;
        protected boolean createDragonFight;
        protected float ambientLighting;
        protected int logicalHeight;
        protected double coordinateMultiplier;

        @Override
        public WorldTypeTemplate.Builder effect(WorldTypeEffect effect) {
            this.effect = Objects.requireNonNull(effect, "effect");
            return this;
        }

        @Override
        public WorldTypeTemplate.Builder biomeSampler(BiomeSampler biomeSampler) {
            this.biomeSampler = Objects.requireNonNull(biomeSampler, "biomeFinder");
            return this;
        }

        @Override
        public WorldTypeTemplate.Builder scorching(boolean scorching) {
            this.scorching = scorching;
            return this;
        }

        @Override
        public WorldTypeTemplate.Builder natural(boolean natural) {
            this.natural = natural;
            return this;
        }

        @Override
        public WorldTypeTemplate.Builder coordinateMultiplier(double coordinateMultiplier) {
            this.coordinateMultiplier = coordinateMultiplier;
            return this;
        }

        @Override
        public WorldTypeTemplate.Builder hasSkylight(boolean skylight) {
            this.skylight = skylight;
            return this;
        }

        @Override
        public WorldTypeTemplate.Builder hasCeiling(boolean ceiling) {
            this.ceiling = ceiling;
            return this;
        }

        @Override
        public WorldTypeTemplate.Builder ambientLighting(float ambientLighting) {
            this.ambientLighting = ambientLighting;
            return this;
        }

        @Override
        public WorldTypeTemplate.Builder fixedTime(@Nullable MinecraftDayTime fixedTime) {
            this.fixedTime = fixedTime;
            return this;
        }

        @Override
        public WorldTypeTemplate.Builder piglinSafe(boolean piglinSafe) {
            this.piglinSafe = piglinSafe;
            return this;
        }

        @Override
        public WorldTypeTemplate.Builder bedsUsable(boolean bedsUsable) {
            this.bedsUsable = bedsUsable;
            return this;
        }

        @Override
        public WorldTypeTemplate.Builder respawnAnchorsUsable(boolean respawnAnchorsUsable) {
            this.respawnAnchorsUsable = respawnAnchorsUsable;
            return this;
        }

        @Override
        public WorldTypeTemplate.Builder hasRaids(boolean hasRaids) {
            this.hasRaids = hasRaids;
            return this;
        }

        @Override
        public WorldTypeTemplate.Builder logicalHeight(int logicalHeight) {
            this.logicalHeight = logicalHeight;
            return this;
        }

        @Override
        public WorldTypeTemplate.Builder createDragonFight(boolean spawnDragonFight) {
            this.createDragonFight = spawnDragonFight;
            return this;
        }

        @Override
        public WorldTypeTemplate.Builder reset() {
            super.reset();
            this.effect = WorldTypeEffects.OVERWORLD;
            this.fixedTime = null;
            this.biomeSampler = BiomeSamplers.COLUMN_FUZZED;
            this.infiniburn = (ResourceKey)BlockTags.field_241277_aC_.func_230234_a_();
            this.scorching = false;
            this.natural = true;
            this.skylight = true;
            this.ceiling = false;
            this.piglinSafe = false;
            this.bedsUsable = true;
            this.respawnAnchorsUsable = false;
            this.hasRaids = true;
            this.ambientLighting = 0.5f;
            this.logicalHeight = 256;
            this.coordinateMultiplier = 1.0;
            this.createDragonFight = false;
            return this;
        }

        @Override
        public WorldTypeTemplate.Builder from(WorldTypeTemplate value) {
            Objects.requireNonNull(value, "value");
            this.effect = value.effect();
            this.biomeSampler = value.biomeSampler();
            this.fixedTime = value.fixedTime().orElse(null);
            this.infiniburn = (ResourceKey)BlockTags.field_241277_aC_.func_230234_a_();
            this.scorching = value.scorching();
            this.natural = value.natural();
            this.skylight = value.hasSkylight();
            this.ceiling = value.hasCeiling();
            this.piglinSafe = value.piglinSafe();
            this.bedsUsable = value.bedsUsable();
            this.respawnAnchorsUsable = value.respawnAnchorsUsable();
            this.hasRaids = value.hasRaids();
            this.ambientLighting = value.ambientLighting();
            this.logicalHeight = value.logicalHeight();
            this.coordinateMultiplier = value.coordinateMultiplier();
            this.createDragonFight = value.createDragonFight();
            return this;
        }

        @Override
        public @NonNull WorldTypeTemplate build0() {
            return new SpongeWorldTypeTemplate(this);
        }
    }

    private static final class SpongeDataSection {
        private final ResourceLocation biomeSampler;
        private final boolean createDragonFight;

        public SpongeDataSection(ResourceLocation biomeSampler, boolean createDragonFight) {
            this.biomeSampler = biomeSampler;
            this.createDragonFight = createDragonFight;
        }
    }
}

