/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.volume.buffer.archetype.blockentity;

import java.util.function.Function;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.fluid.FluidState;
import org.spongepowered.api.world.schematic.Palette;
import org.spongepowered.api.world.volume.archetype.block.entity.BlockEntityArchetypeVolume;
import org.spongepowered.api.world.volume.stream.StreamOptions;
import org.spongepowered.api.world.volume.stream.VolumeElement;
import org.spongepowered.api.world.volume.stream.VolumeStream;
import org.spongepowered.common.bridge.block.BlockStateBridge;
import org.spongepowered.common.world.volume.SpongeVolumeStream;
import org.spongepowered.common.world.volume.VolumeStreamUtils;
import org.spongepowered.common.world.volume.buffer.block.AbstractBlockBuffer;
import org.spongepowered.common.world.volume.buffer.block.ArrayMutableBlockBuffer;
import org.spongepowered.math.vector.Vector3i;

public abstract class AbstractMutableBlockEntityArchetypeBuffer<M extends AbstractMutableBlockEntityArchetypeBuffer<M>>
extends AbstractBlockBuffer
implements BlockEntityArchetypeVolume.Mutable<M> {
    private final ArrayMutableBlockBuffer blockBuffer;

    protected AbstractMutableBlockEntityArchetypeBuffer(Vector3i start, Vector3i size) {
        super(start, size);
        this.blockBuffer = new ArrayMutableBlockBuffer(start, size);
    }

    protected AbstractMutableBlockEntityArchetypeBuffer(ArrayMutableBlockBuffer buffer) {
        super(buffer.getBlockMin(), buffer.getBlockSize());
        this.blockBuffer = buffer;
    }

    @Override
    public boolean setBlock(int x, int y, int z, BlockState block) {
        if (this.blockBuffer.setBlock(x, y, z, block) && ((BlockStateBridge)((Object)block)).bridge$hasTileEntity()) {
            this.removeBlockEntity(x, y, z);
        }
        return false;
    }

    @Override
    public boolean removeBlock(int x, int y, int z) {
        if (this.blockBuffer.removeBlock(x, y, z)) {
            this.removeBlockEntity(x, y, z);
        }
        return false;
    }

    @Override
    public Palette<BlockState, BlockType> getPalette() {
        return this.blockBuffer.getPalette();
    }

    @Override
    public BlockState getBlock(int x, int y, int z) {
        return this.blockBuffer.getBlock(x, y, z);
    }

    @Override
    public FluidState getFluid(int x, int y, int z) {
        return this.blockBuffer.getFluid(x, y, z);
    }

    @Override
    public int getHighestYAt(int x, int z) {
        return this.blockBuffer.getHighestYAt(x, z);
    }

    @Override
    public VolumeStream<M, BlockState> getBlockStateStream(Vector3i min2, Vector3i max, StreamOptions options) {
        Vector3i blockMin = this.getBlockMin();
        Vector3i blockMax = this.getBlockMax();
        VolumeStreamUtils.validateStreamArgs(min2, max, blockMin, blockMax, options);
        ArrayMutableBlockBuffer buffer = options.carbonCopy() ? this.blockBuffer.copy() : this.blockBuffer;
        Stream stateStream = IntStream.range(blockMin.getX(), blockMax.getX() + 1).mapToObj(x -> IntStream.range(blockMin.getZ(), blockMax.getZ() + 1).mapToObj(z -> IntStream.range(blockMin.getY(), blockMax.getY() + 1).mapToObj(y -> VolumeElement.of(this, () -> buffer.getBlock(x, y, z), new Vector3i(x, y, z)))).flatMap(Function.identity())).flatMap(Function.identity());
        return new SpongeVolumeStream(stateStream, () -> this);
    }
}

