/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.volume.buffer.archetype.blockentity;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.spongepowered.api.block.entity.BlockEntity;
import org.spongepowered.api.block.entity.BlockEntityArchetype;
import org.spongepowered.api.world.volume.stream.StreamOptions;
import org.spongepowered.api.world.volume.stream.VolumeElement;
import org.spongepowered.api.world.volume.stream.VolumeStream;
import org.spongepowered.common.world.volume.SpongeVolumeStream;
import org.spongepowered.common.world.volume.VolumeStreamUtils;
import org.spongepowered.common.world.volume.buffer.archetype.blockentity.AbstractMutableBlockEntityArchetypeBuffer;
import org.spongepowered.common.world.volume.buffer.block.ArrayMutableBlockBuffer;
import org.spongepowered.math.vector.Vector3i;

public class MutableMapBlockEntityArchetypeBuffer
extends AbstractMutableBlockEntityArchetypeBuffer<MutableMapBlockEntityArchetypeBuffer> {
    private final Map<Vector3i, BlockEntityArchetype> blockEntities = new HashMap<Vector3i, BlockEntityArchetype>();

    public MutableMapBlockEntityArchetypeBuffer(Vector3i start, Vector3i size) {
        super(start, size);
    }

    public MutableMapBlockEntityArchetypeBuffer(ArrayMutableBlockBuffer buffer) {
        super(buffer);
    }

    @Override
    public void addBlockEntity(int x, int y, int z, BlockEntityArchetype archetype) {
        this.checkRange(x, y, z);
        this.blockEntities.put(new Vector3i(x, y, z), Objects.requireNonNull(archetype, "Archetype cannot be null"));
    }

    @Override
    public void addBlockEntity(Vector3i pos, BlockEntity blockEntity) {
        this.checkRange(pos.getX(), pos.getY(), pos.getZ());
        this.blockEntities.put(Objects.requireNonNull(pos, "Position cannot be null"), Objects.requireNonNull(blockEntity, "BlockEntity cannot be null").createArchetype());
    }

    @Override
    public void addBlockEntity(int x, int y, int z, BlockEntity blockEntity) {
        this.checkRange(x, y, z);
        this.blockEntities.put(new Vector3i(x, y, z), Objects.requireNonNull(blockEntity, "BlockEntity cannot be null").createArchetype());
    }

    @Override
    public void addBlockEntity(Vector3i pos, BlockEntityArchetype archetype) {
        this.checkRange(pos.getX(), pos.getY(), pos.getZ());
        this.blockEntities.put(Objects.requireNonNull(pos, "Position cannot be null"), Objects.requireNonNull(archetype, "Archetype cannot be null"));
    }

    @Override
    public void removeBlockEntity(int x, int y, int z) {
        this.checkRange(x, y, z);
        this.blockEntities.remove(new Vector3i(x, y, z));
    }

    @Override
    public Optional<BlockEntityArchetype> getBlockEntityArchetype(int x, int y, int z) {
        return Optional.ofNullable(this.blockEntities.get(new Vector3i(x, y, z)));
    }

    @Override
    public Map<Vector3i, BlockEntityArchetype> getBlockEntityArchetypes() {
        return this.blockEntities;
    }

    @Override
    public VolumeStream<MutableMapBlockEntityArchetypeBuffer, BlockEntityArchetype> getBlockEntityArchetypeStream(Vector3i min2, Vector3i max, StreamOptions options) {
        Stream entryStream;
        VolumeStreamUtils.validateStreamArgs(min2, max, this.getBlockMin(), this.getBlockMax(), options);
        if (options.carbonCopy()) {
            HashMap copy = new HashMap();
            this.blockEntities.forEach((vector3i, archetype) -> copy.put(vector3i, archetype.copy()));
            entryStream = copy.entrySet().stream();
        } else {
            entryStream = this.blockEntities.entrySet().stream();
        }
        Stream volumeElementStream = entryStream.filter(VolumeStreamUtils.blockEntityArchetypePositionFilter(min2, max)).map(entry -> VolumeElement.of(this, entry.getValue(), (Vector3i)entry.getKey()));
        return new SpongeVolumeStream<MutableMapBlockEntityArchetypeBuffer, BlockEntityArchetype>(volumeElementStream, () -> this);
    }
}

