/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.volume.buffer.archetype.entity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.spongepowered.api.entity.EntityArchetype;
import org.spongepowered.api.util.Tuple;
import org.spongepowered.api.world.volume.archetype.entity.EntityArchetypeEntry;
import org.spongepowered.api.world.volume.archetype.entity.EntityArchetypeVolume;
import org.spongepowered.api.world.volume.stream.StreamOptions;
import org.spongepowered.api.world.volume.stream.VolumeElement;
import org.spongepowered.api.world.volume.stream.VolumeStream;
import org.spongepowered.common.world.volume.SpongeVolumeStream;
import org.spongepowered.common.world.volume.VolumeStreamUtils;
import org.spongepowered.common.world.volume.buffer.AbstractVolumeBuffer;
import org.spongepowered.math.vector.Vector3d;
import org.spongepowered.math.vector.Vector3i;

public class ObjectArrayMutableEntityArchetypeBuffer
extends AbstractVolumeBuffer
implements EntityArchetypeVolume.Mutable<ObjectArrayMutableEntityArchetypeBuffer> {
    private final ArrayList<Tuple<Vector3d, EntityArchetype>> entities = new ArrayList();

    public ObjectArrayMutableEntityArchetypeBuffer(Vector3i start, Vector3i size) {
        super(start, size);
    }

    @Override
    public Collection<EntityArchetype> getEntityArchetypes() {
        return this.entities.stream().map(Tuple::getSecond).collect(Collectors.toList());
    }

    @Override
    public Collection<EntityArchetype> getEntityArchetypes(Predicate<EntityArchetype> filter) {
        return this.entities.stream().map(Tuple::getSecond).filter(filter).collect(Collectors.toList());
    }

    @Override
    public VolumeStream<ObjectArrayMutableEntityArchetypeBuffer, EntityArchetype> getEntityArchetypeStream(Vector3i min2, Vector3i max, StreamOptions options) {
        VolumeStreamUtils.validateStreamArgs(min2, max, this.getBlockMin(), this.getBlockMax(), options);
        Stream entryStream = options.carbonCopy() ? new ArrayList<Tuple<Vector3d, EntityArchetype>>(this.entities).stream() : this.entities.stream();
        Stream archetypeStream = entryStream.filter(VolumeStreamUtils.entityArchetypePositionFilter(min2, max)).map(tuple -> VolumeElement.of(this, tuple.getSecond(), ((Vector3d)tuple.getFirst()).toInt()));
        return new SpongeVolumeStream<ObjectArrayMutableEntityArchetypeBuffer, EntityArchetype>(archetypeStream, () -> this);
    }

    @Override
    public Stream<EntityArchetypeEntry> getEntitiesByPosition() {
        return this.entities.stream().map(tuple -> EntityArchetypeEntry.of((EntityArchetype)tuple.getSecond(), (Vector3d)tuple.getFirst()));
    }

    @Override
    public void addEntity(EntityArchetypeEntry entry) {
        if (!this.containsBlock(Objects.requireNonNull(entry, "EntityArchetype cannot be null").getPosition().toInt())) {
            String message = String.format("EntityArchetype position is out of bounds: Found %s but is outside bounds (%s, %s)", entry.getPosition(), this.getBlockMin(), this.getBlockMax());
            throw new IllegalArgumentException(message);
        }
        this.entities.add(Tuple.of(entry.getPosition(), entry.getArchetype()));
    }
}

