/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.volume.buffer.biome;

import java.util.Arrays;
import java.util.function.Function;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.world.biome.Biome;
import org.spongepowered.api.world.volume.biome.BiomeVolume;
import org.spongepowered.api.world.volume.stream.StreamOptions;
import org.spongepowered.api.world.volume.stream.VolumeElement;
import org.spongepowered.api.world.volume.stream.VolumeStream;
import org.spongepowered.common.world.volume.SpongeVolumeStream;
import org.spongepowered.common.world.volume.VolumeStreamUtils;
import org.spongepowered.common.world.volume.buffer.biome.AbstractBiomeBuffer;
import org.spongepowered.math.vector.Vector3i;

public final class ObjectArrayImmutableBiomeBuffer
extends AbstractBiomeBuffer
implements BiomeVolume.Immutable {
    private final Biome[] biomes;

    public ObjectArrayImmutableBiomeBuffer(Biome[] biomes, Vector3i start, Vector3i size) {
        super(start, size);
        this.biomes = (Biome[])biomes.clone();
    }

    @Override
    public Biome getBiome(int x, int y, int z) {
        this.checkRange(x, y, z);
        return this.biomes[this.getIndex(x, y, z)];
    }

    public net.minecraft.world.biome.Biome getNativeBiome(int x, int y, int z) {
        this.checkRange(x, y, z);
        Biome type = this.biomes[this.getIndex(x, y, z)];
        return (net.minecraft.world.biome.Biome)type;
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ObjectArrayImmutableBiomeBuffer that = (ObjectArrayImmutableBiomeBuffer)o;
        return Arrays.equals(this.biomes, that.biomes);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.biomes);
        return result;
    }

    @Override
    public VolumeStream<BiomeVolume.Immutable, Biome> getBiomeStream(Vector3i min2, Vector3i max, StreamOptions options) {
        VolumeStreamUtils.validateStreamArgs(min2, max, options);
        Stream stateStream = IntStream.range(this.getBlockMin().getX(), this.getBlockMax().getX() + 1).mapToObj(x -> IntStream.range(this.getBlockMin().getZ(), this.getBlockMax().getZ() + 1).mapToObj(z -> IntStream.range(this.getBlockMin().getY(), this.getBlockMax().getY() + 1).mapToObj(y -> VolumeElement.of(this, () -> this.biomes[this.getIndex(x, y, z)], new Vector3i(x, y, z)))).flatMap(Function.identity())).flatMap(Function.identity());
        return new SpongeVolumeStream<BiomeVolume.Immutable, Biome>(stateStream, () -> this);
    }
}

