/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.vanilla.applaunch;

import cpw.mods.modlauncher.Launcher;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.common.applaunch.config.core.SpongeConfigs;
import org.spongepowered.plugin.PluginEnvironment;
import org.spongepowered.plugin.PluginKeys;
import org.spongepowered.vanilla.applaunch.AppCommandLine;
import org.spongepowered.vanilla.applaunch.plugin.VanillaPluginEngine;
import org.spongepowered.vanilla.applaunch.util.ArgumentList;

public final class Main {
    private static Main instance;
    private final Logger logger;
    private final VanillaPluginEngine pluginEngine;

    public Main() {
        instance = this;
        this.logger = LogManager.getLogger("App Launch");
        this.pluginEngine = new VanillaPluginEngine(new PluginEnvironment());
    }

    public static void main(String[] args) throws Exception {
        AppCommandLine.configure(args);
        new Main().run();
    }

    public static Main getInstance() {
        return instance;
    }

    public void run() throws IOException {
        String implementationVersion = PluginEnvironment.class.getPackage().getImplementationVersion();
        this.pluginEngine.getPluginEnvironment().getBlackboard().getOrCreate(PluginKeys.VERSION, () -> implementationVersion == null ? "dev" : implementationVersion);
        this.pluginEngine.getPluginEnvironment().getBlackboard().getOrCreate(PluginKeys.BASE_DIRECTORY, () -> AppCommandLine.gameDirectory);
        SpongeConfigs.initialize(this.pluginEngine.getPluginEnvironment());
        Path modsDirectory = AppCommandLine.gameDirectory.resolve("mods");
        if (Files.notExists(modsDirectory, new LinkOption[0])) {
            Files.createDirectories(modsDirectory, new FileAttribute[0]);
        }
        Path pluginsDirectory = AppCommandLine.gameDirectory.resolve("plugins");
        ArrayList<Path> pluginDirectories = new ArrayList<Path>();
        pluginDirectories.add(modsDirectory);
        if (Files.exists(pluginsDirectory, new LinkOption[0])) {
            pluginDirectories.add(pluginsDirectory);
        }
        this.pluginEngine.getPluginEnvironment().getBlackboard().getOrCreate(PluginKeys.PLUGIN_DIRECTORIES, () -> pluginDirectories);
        this.logger.info("Transitioning to ModLauncher, please wait...");
        ArgumentList lst = ArgumentList.from(AppCommandLine.RAW_ARGS);
        Launcher.main((String[])lst.getArguments());
    }

    public VanillaPluginEngine getPluginEngine() {
        return this.pluginEngine;
    }
}

