/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.vanilla.applaunch.handler;

import cpw.mods.modlauncher.api.ILaunchHandlerService;
import cpw.mods.modlauncher.api.ITransformingClassLoader;
import cpw.mods.modlauncher.api.ITransformingClassLoaderBuilder;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.jar.Manifest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.plugin.PluginResource;
import org.spongepowered.plugin.jvm.locator.JVMPluginResource;
import org.spongepowered.plugin.jvm.locator.ResourceType;
import org.spongepowered.vanilla.applaunch.Main;

public abstract class AbstractVanillaLaunchHandler
implements ILaunchHandlerService {
    protected final Logger logger = LogManager.getLogger("Launch");
    protected static final List<String> EXCLUDED_PACKAGES = Arrays.asList("org.spongepowered.plugin.", "org.spongepowered.common.applaunch.", "org.spongepowered.vanilla.applaunch.", "io.leangen.geantyref.", "org.spongepowered.configurate.");
    protected static final List<String> EXCLUDED_EXCEPTIONS = Arrays.asList("org.spongepowered.configurate.objectmapping.guice.");
    private final ConcurrentMap<URL, Optional<Manifest>> manifestCache = new ConcurrentHashMap<URL, Optional<Manifest>>();
    private static final Optional<Manifest> UNKNOWN_MANIFEST = Optional.of(new Manifest());

    public void configureTransformationClassLoader(ITransformingClassLoaderBuilder builder) {
        builder.setResourceEnumeratorLocator(this.getResourceLocator());
        builder.setManifestLocator(this.getManifestLocator());
    }

    public Callable<Void> launchService(String[] arguments, ITransformingClassLoader launchClassLoader) {
        this.logger.info("Transitioning to Sponge launcher, please wait...");
        launchClassLoader.addTargetPackageFilter(klass -> {
            block0: for (String pkg : EXCLUDED_PACKAGES) {
                if (!klass.startsWith(pkg)) continue;
                for (String bypass : EXCLUDED_EXCEPTIONS) {
                    if (!klass.startsWith(bypass)) continue;
                    continue block0;
                }
                return false;
            }
            return true;
        });
        return () -> {
            this.launchService0(arguments, launchClassLoader);
            return null;
        };
    }

    protected Function<String, Enumeration<URL>> getResourceLocator() {
        return s2 -> {
            if (s2.startsWith("net/minecraft") || s2.startsWith("it/unimi")) {
                return Collections.emptyEnumeration();
            }
            return new Enumeration<URL>(){
                URL next;
                final Iterator serviceResources = Main.getInstance().getPluginEngine().getResources().values().iterator();
                Iterator resources;
                {
                    this.next = this.computeNext();
                }

                @Override
                public boolean hasMoreElements() {
                    return this.next != null;
                }

                @Override
                public URL nextElement() {
                    URL next = this.next;
                    if (next == null) {
                        throw new NoSuchElementException();
                    }
                    this.next = this.computeNext();
                    return next;
                }

                private URL computeNext() {
                    Path resolved;
                    PluginResource resource;
                    do {
                        if (this.resources != null && !this.resources.hasNext()) {
                            this.resources = null;
                        }
                        if (this.resources != null) continue;
                        if (!this.serviceResources.hasNext()) {
                            return null;
                        }
                        this.resources = ((List)this.serviceResources.next()).iterator();
                    } while (!this.resources.hasNext() || (resource = (PluginResource)this.resources.next()) instanceof JVMPluginResource && ((JVMPluginResource)resource).getType() != ResourceType.JAR || !Files.exists(resolved = resource.getFileSystem().getPath(s2, new String[0]), new LinkOption[0]));
                    try {
                        return resolved.toUri().toURL();
                    }
                    catch (MalformedURLException ex) {
                        throw new RuntimeException(ex);
                    }
                }
            };
        };
    }

    private Function<URLConnection, Optional<Manifest>> getManifestLocator() {
        return connection -> {
            if (connection instanceof JarURLConnection) {
                URL jarFileUrl = ((JarURLConnection)connection).getJarFileURL();
                Optional manifest = this.manifestCache.computeIfAbsent(jarFileUrl, key -> {
                    for (List<PluginResource> resources : Main.getInstance().getPluginEngine().getResources().values()) {
                        for (PluginResource resource : resources) {
                            if (!(resource instanceof JVMPluginResource)) continue;
                            JVMPluginResource jvmResource = (JVMPluginResource)resource;
                            try {
                                if (jvmResource.getType() != ResourceType.JAR || !resource.getPath().toAbsolutePath().normalize().equals(Paths.get(key.toURI()).toAbsolutePath().normalize())) continue;
                                return jvmResource.getManifest();
                            }
                            catch (URISyntaxException ex) {
                                this.logger.error("Failed to load manifest from jar {}: ", key, (Object)ex);
                            }
                        }
                    }
                    return UNKNOWN_MANIFEST;
                });
                try {
                    if (manifest == UNKNOWN_MANIFEST) {
                        return Optional.ofNullable(((JarURLConnection)connection).getManifest());
                    }
                    return manifest;
                }
                catch (IOException ex) {
                    this.logger.error("Failed to load manifest from jar {}: ", (Object)jarFileUrl, (Object)ex);
                }
            }
            return Optional.empty();
        };
    }

    protected abstract void launchService0(String[] var1, ITransformingClassLoader var2) throws Exception;
}

