/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.vanilla.client.gui.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IRenderable;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.spongepowered.common.launch.Launch;
import org.spongepowered.plugin.PluginContainer;
import org.spongepowered.plugin.metadata.PluginMetadata;
import org.spongepowered.vanilla.client.gui.widget.MetadataPanel;
import org.spongepowered.vanilla.client.gui.widget.list.PluginSelectionList;

public final class PluginScreen
extends Screen {
    private final Screen previousScreen;
    private final List<PluginMetadata> metadata;
    private PluginSelectionList selectionList;
    private MetadataPanel contentPanel;
    private TextFieldWidget searchField;

    public PluginScreen(Screen previousScreen) {
        super((ITextComponent)new StringTextComponent("Plugins"));
        this.previousScreen = previousScreen;
        this.metadata = new ObjectArrayList();
        Collection<PluginContainer> plugins = ((Launch)Launch.getInstance()).getPluginManager().getPlugins();
        this.metadata.addAll(plugins.stream().map(PluginContainer::getMetadata).collect(Collectors.toList()));
    }

    protected void func_231160_c_() {
        Minecraft.func_71410_x().field_195559_v.func_197967_a(true);
        int listHeight = this.field_230709_l_ - 122;
        this.selectionList = new PluginSelectionList(this, 4, 58, 175, listHeight, 26);
        this.contentPanel = new MetadataPanel(this.field_230706_i_, this, this.field_230708_k_ - this.selectionList.getWidth() - 12, listHeight, 58, this.selectionList.getRight() + 4);
        this.selectionList.setSelectConsumer(e -> this.contentPanel.setMetadata(e == null ? null : e.metadata));
        this.generateEntries(((Launch)Launch.getInstance()).getPluginManager().getPlugins().stream().map(PluginContainer::getMetadata).collect(Collectors.toList()));
        this.searchField = new TextFieldWidget(this.field_230712_o_, this.field_230708_k_ / 2 - 100, 22, 200, 20, (ITextComponent)new TranslationTextComponent(I18n.func_135052_a((String)"itemGroup.search", (Object[])new Object[0])));
        this.searchField.func_212954_a(value -> this.selectionList.setFilterSupplier(() -> {
            List filteredList = this.selectionList.func_231039_at__().stream().filter(entry -> entry.metadata.getName().orElse("").toLowerCase().contains(value.toLowerCase()) || entry.metadata.getId().toLowerCase().contains(value.toLowerCase())).collect(Collectors.toList());
            if (!filteredList.contains(this.selectionList.func_230958_g_())) {
                this.selectionList.setSelected(filteredList.stream().findFirst().orElse(null));
            }
            return filteredList;
        }));
        this.field_230705_e_.addAll(Arrays.asList(new AbstractGui[]{this.selectionList, this.contentPanel, this.searchField}));
        this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 - 50, this.field_230709_l_ - 40, 100, 20, (ITextComponent)new TranslationTextComponent(I18n.func_135052_a((String)"gui.done", (Object[])new Object[0])), p_214323_1_ -> Minecraft.func_71410_x().func_147108_a(this.previousScreen)));
    }

    public void func_230430_a_(MatrixStack stack, int p_render_1_, int p_render_2_, float p_render_3_) {
        this.func_230446_a_(stack);
        this.field_230705_e_.stream().filter(child -> child instanceof IRenderable).forEach(child -> ((IRenderable)child).func_230430_a_(stack, p_render_1_, p_render_2_, p_render_3_));
        Screen.func_238471_a_((MatrixStack)stack, (FontRenderer)this.field_230712_o_, (String)this.field_230704_d_.getString(), (int)(this.field_230708_k_ / 2), (int)8, (int)0xFFFFFF);
        super.func_230430_a_(stack, p_render_1_, p_render_2_, p_render_3_);
    }

    private void generateEntries(List<PluginMetadata> metadatas) {
        if (this.selectionList == null) {
            return;
        }
        this.selectionList.func_231039_at__().clear();
        this.selectionList.func_231039_at__().addAll(metadatas.stream().map(metadata -> new PluginSelectionList.Entry(this.selectionList, (PluginMetadata)metadata)).collect(Collectors.toList()));
        this.selectionList.setSelected(this.selectionList.func_231039_at__().stream().findFirst().orElse(null));
    }
}

