/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.vanilla.launch.plugin;

import com.google.inject.Singleton;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.spongepowered.common.launch.plugin.DummyPluginContainer;
import org.spongepowered.common.launch.plugin.SpongePluginManager;
import org.spongepowered.plugin.InvalidPluginException;
import org.spongepowered.plugin.PluginCandidate;
import org.spongepowered.plugin.PluginContainer;
import org.spongepowered.plugin.PluginLanguageService;
import org.spongepowered.plugin.PluginLoader;
import org.spongepowered.plugin.PluginResource;
import org.spongepowered.vanilla.applaunch.plugin.VanillaPluginEngine;
import org.spongepowered.vanilla.launch.VanillaLaunch;

@Singleton
public final class VanillaPluginManager
implements SpongePluginManager {
    private final Map<String, PluginContainer> plugins = new Object2ObjectOpenHashMap();
    private final Map<Object, PluginContainer> instancesToPlugins = new IdentityHashMap<Object, PluginContainer>();
    private final List<PluginContainer> sortedPlugins = new ArrayList<PluginContainer>();

    @Override
    public Optional<PluginContainer> fromInstance(Object instance) {
        Objects.requireNonNull(instance);
        return Optional.ofNullable(this.instancesToPlugins.get(instance));
    }

    @Override
    public Optional<PluginContainer> getPlugin(String id) {
        Objects.requireNonNull(id);
        return Optional.ofNullable(this.plugins.get(id));
    }

    @Override
    public Collection<PluginContainer> getPlugins() {
        return Collections.unmodifiableCollection(this.sortedPlugins);
    }

    @Override
    public boolean isLoaded(String id) {
        Objects.requireNonNull(id);
        return this.plugins.containsKey(id);
    }

    @Override
    public void addPlugin(PluginContainer plugin) {
        Objects.requireNonNull(plugin);
        this.plugins.put(plugin.getMetadata().getId(), plugin);
        this.instancesToPlugins.put(plugin.getInstance(), plugin);
        this.sortedPlugins.add(plugin);
    }

    @Override
    public void addDummyPlugin(DummyPluginContainer plugin) {
        Objects.requireNonNull(plugin);
        this.plugins.put(plugin.getMetadata().getId(), plugin);
        this.sortedPlugins.add(plugin);
    }

    public void loadPlugins(VanillaPluginEngine engine) {
        for (Map.Entry<PluginLanguageService<PluginResource>, List<PluginCandidate<PluginResource>>> languageCandidates : engine.getCandidates().entrySet()) {
            PluginLoader pluginLoader;
            PluginLanguageService<PluginResource> languageService = languageCandidates.getKey();
            Collection candidates = languageCandidates.getValue();
            String loaderClass = languageService.getPluginLoader();
            try {
                pluginLoader = (PluginLoader)Class.forName(loaderClass).newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
            for (PluginCandidate candidate : candidates) {
                PluginContainer plugin = this.plugins.get(candidate.getMetadata().getId());
                if (plugin != null) {
                    if (!(plugin instanceof DummyPluginContainer)) continue;
                    continue;
                }
                plugin = pluginLoader.createPluginContainer(candidate, engine.getPluginEnvironment()).orElse(null);
                if (plugin == null) {
                    engine.getPluginEnvironment().getLogger().debug("Language service '{}' returned a null plugin container for '{}'.", (Object)languageService.getName(), (Object)candidate.getMetadata().getId());
                    continue;
                }
                try {
                    pluginLoader.loadPlugin(engine.getPluginEnvironment(), plugin, VanillaLaunch.getInstance().getClass().getClassLoader());
                    this.addPlugin(plugin);
                }
                catch (InvalidPluginException e) {
                    e.printStackTrace();
                }
            }
        }
        engine.getPluginEnvironment().getLogger().info("Loaded plugin(s): {}", (Object)this.sortedPlugins.stream().map(p -> p.getMetadata().getId()).collect(Collectors.toList()));
    }
}

