/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data;

import java.util.Comparator;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.function.BiPredicate;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.data.KeyValueMatcher;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.Queries;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.common.util.Constants;

public final class SpongeKeyValueMatcher<V>
implements KeyValueMatcher<V> {
    private final Key<? extends Value<V>> key;
    private final KeyValueMatcher.Operator operator;
    private final @Nullable V value;

    public SpongeKeyValueMatcher(Key<? extends Value<V>> key, KeyValueMatcher.Operator operator, @Nullable V value) {
        this.key = key;
        this.operator = operator;
        this.value = value;
    }

    @Override
    public Key<? extends Value<V>> key() {
        return this.key;
    }

    @Override
    public KeyValueMatcher.Operator operator() {
        return this.operator;
    }

    @Override
    public Optional<V> value() {
        return Optional.ofNullable(this.value);
    }

    @Override
    public boolean matches(@Nullable V value) {
        switch (this.operator) {
            case EQUAL: {
                return this.compare(value) == 0;
            }
            case NOT_EQUAL: {
                return this.compare(value) != 0;
            }
            case GREATER: {
                return this.compare(value) > 0;
            }
            case GREATER_OR_EQUAL: {
                return this.compare(value) >= 0;
            }
            case LESS: {
                return this.compare(value) < 0;
            }
            case LESS_OR_EQUAL: {
                return this.compare(value) <= 0;
            }
            case INCLUDES: {
                return this.includes(value);
            }
            case EXCLUDES: {
                return !this.includes(value);
            }
        }
        throw new IllegalStateException("Unknown operator: " + (Object)((Object)this.operator));
    }

    private boolean includes(@Nullable V value) {
        if (this.value == null || value == null) {
            return false;
        }
        BiPredicate<?, ?> predicate = this.key.elementIncludesTester();
        return predicate.test(this.value, value);
    }

    private int compare(@Nullable V value) {
        if (this.value == null && value == null) {
            return 0;
        }
        if (this.value != null && value == null) {
            return 1;
        }
        if (this.value == null) {
            return -1;
        }
        Comparator<?> comparator = this.key.elementComparator();
        return -comparator.compare(this.value, value);
    }

    @Override
    public int contentVersion() {
        return 1;
    }

    @Override
    public DataContainer toContainer() {
        DataContainer container = DataContainer.createNew().set(Queries.CONTENT_VERSION, this.contentVersion()).set(Constants.KeyValueMatcher.KEY, this.key).set(Constants.KeyValueMatcher.OPERATOR, this.operator.toString().toLowerCase());
        if (this.value != null) {
            container.set(Constants.KeyValueMatcher.VALUE, this.value);
        }
        return container;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpongeKeyValueMatcher that = (SpongeKeyValueMatcher)o;
        return this.key.equals(that.key) && this.operator == that.operator && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.key, this.operator, this.value});
    }

    public String toString() {
        return new StringJoiner(", ", SpongeKeyValueMatcher.class.getSimpleName() + "[", "]").add("key=" + this.key).add("operator=" + (Object)((Object)this.operator)).add("value=" + this.value).toString();
    }
}

