/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.entity.ai.goal.builtin.creature.target;

import com.google.common.base.Preconditions;
import java.util.function.Predicate;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.entity.ai.goal.builtin.creature.target.FindNearestAttackableTargetGoal;
import org.spongepowered.api.entity.living.Creature;
import org.spongepowered.api.entity.living.Living;
import org.spongepowered.common.entity.ai.goal.builtin.creature.target.SpongeTargetGoalBuilder;

public final class SpongeFindNearestAttackableTargetGoalBuilder
extends SpongeTargetGoalBuilder<FindNearestAttackableTargetGoal, FindNearestAttackableTargetGoal.Builder>
implements FindNearestAttackableTargetGoal.Builder {
    private static final Predicate<LivingEntity> ALWAYS_TRUE = e -> true;
    private Class<? extends Living> targetClass;
    private int chance;
    private @Nullable Predicate<? extends LivingEntity> predicate;

    public SpongeFindNearestAttackableTargetGoalBuilder() {
        this.reset();
    }

    @Override
    public FindNearestAttackableTargetGoal.Builder target(Class<? extends Living> targetClass) {
        this.targetClass = targetClass;
        return this;
    }

    @Override
    public FindNearestAttackableTargetGoal.Builder chance(int chance) {
        this.chance = chance;
        return this;
    }

    @Override
    public FindNearestAttackableTargetGoal.Builder filter(Predicate<? extends Living> predicate) {
        this.predicate = predicate;
        return this;
    }

    @Override
    public FindNearestAttackableTargetGoal.Builder from(FindNearestAttackableTargetGoal value) {
        Preconditions.checkNotNull((Object)value);
        this.targetClass = value.targetClass();
        this.checkSight = value.shouldCheckSight();
        this.checkOnlyNearby = value.shouldCheckOnlyNearby();
        this.chance = value.chance();
        this.predicate = value.filter();
        return this;
    }

    @Override
    public FindNearestAttackableTargetGoal.Builder reset() {
        this.checkSight = false;
        this.checkOnlyNearby = false;
        this.targetClass = null;
        this.predicate = null;
        return this;
    }

    @Override
    public FindNearestAttackableTargetGoal build(Creature owner) {
        Preconditions.checkNotNull((Object)owner);
        Preconditions.checkNotNull(this.targetClass);
        return (FindNearestAttackableTargetGoal)new NearestAttackableTargetGoal((Mob)((PathfinderMob)owner), this.targetClass, this.chance, this.checkSight, this.checkOnlyNearby, this.predicate == null ? ALWAYS_TRUE : this.predicate);
    }
}

