/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event;

import io.leangen.geantyref.TypeToken;
import java.lang.reflect.Type;
import java.util.Objects;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.event.EventListener;
import org.spongepowered.api.event.EventListenerRegistration;
import org.spongepowered.api.event.Order;
import org.spongepowered.plugin.PluginContainer;

public final class SpongeEventListenerRegistration<T extends Event>
implements EventListenerRegistration<T> {
    private final Type eventType;
    private final PluginContainer plugin;
    private final Order order;
    private final boolean beforeModifications;
    private final EventListener<? super T> listener;

    private SpongeEventListenerRegistration(BuilderImpl<T> builder) {
        this.eventType = builder.eventType;
        this.plugin = builder.plugin;
        this.order = builder.order;
        this.beforeModifications = builder.beforeModifications;
        this.listener = builder.listener;
    }

    @Override
    public Type eventType() {
        return this.eventType;
    }

    @Override
    public PluginContainer plugin() {
        return this.plugin;
    }

    @Override
    public Order order() {
        return this.order;
    }

    @Override
    public boolean beforeModifications() {
        return this.beforeModifications;
    }

    @Override
    public EventListener<? super T> listener() {
        return this.listener;
    }

    public static final class BuilderImpl<T extends Event>
    implements EventListenerRegistration.Builder<T> {
        final Type eventType;
        PluginContainer plugin;
        Order order;
        boolean beforeModifications;
        EventListener<? super T> listener;

        private BuilderImpl(TypeToken<T> eventType) {
            this.eventType = eventType.getType();
        }

        @Override
        public EventListenerRegistration.Builder<T> plugin(PluginContainer plugin) {
            this.plugin = Objects.requireNonNull(plugin, "plugin");
            return this;
        }

        @Override
        public EventListenerRegistration.Builder<T> order(Order order) {
            this.order = order;
            return this;
        }

        @Override
        public EventListenerRegistration.Builder<T> beforeModifications(boolean beforeModifications) {
            this.beforeModifications = beforeModifications;
            return this;
        }

        @Override
        public EventListenerRegistration.Builder<T> listener(EventListener<? super T> listener) {
            this.listener = Objects.requireNonNull(listener, "listener");
            return this;
        }

        @Override
        public EventListenerRegistration.Builder<T> reset() {
            this.plugin = null;
            this.order = Order.DEFAULT;
            this.beforeModifications = false;
            this.listener = null;
            return this;
        }

        @Override
        public EventListenerRegistration<T> build() {
            Objects.requireNonNull(this.plugin, "plugin");
            Objects.requireNonNull(this.listener, "listener");
            return new SpongeEventListenerRegistration(this);
        }
    }

    public static final class FactoryImpl
    implements EventListenerRegistration.Factory {
        @Override
        public <T extends Event> EventListenerRegistration.Builder<T> builder(TypeToken<T> eventType) {
            return new BuilderImpl(Objects.requireNonNull(eventType, "eventType"));
        }
    }
}

