/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.context.transaction.block;

import java.util.Optional;
import java.util.StringJoiner;
import java.util.function.BiConsumer;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.block.ChangeBlockEvent;
import org.spongepowered.common.block.SpongeBlockSnapshot;
import org.spongepowered.common.event.tracking.BlockChangeFlagManager;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.context.transaction.GameTransaction;
import org.spongepowered.common.event.tracking.context.transaction.block.BlockEventBasedTransaction;
import org.spongepowered.common.event.tracking.context.transaction.block.PrepareBlockDropsTransaction;
import org.spongepowered.common.event.tracking.context.transaction.effect.BlockAddedEffect;
import org.spongepowered.common.event.tracking.context.transaction.effect.CheckBlockPostPlacementIsSameEffect;
import org.spongepowered.common.event.tracking.context.transaction.effect.ChunkChangeCompleteEffect;
import org.spongepowered.common.event.tracking.context.transaction.effect.OldBlockOnReplaceEffect;
import org.spongepowered.common.event.tracking.context.transaction.effect.RefreshOldTileEntityOnChunkChangeEffect;
import org.spongepowered.common.event.tracking.context.transaction.effect.SetBlockToChunkSectionEffect;
import org.spongepowered.common.event.tracking.context.transaction.effect.UpdateChunkLightManagerEffect;
import org.spongepowered.common.event.tracking.context.transaction.effect.UpdateHeightMapEffect;
import org.spongepowered.common.event.tracking.context.transaction.effect.UpdateOrCreateNewTileEntityPostPlacementEffect;
import org.spongepowered.common.event.tracking.context.transaction.pipeline.ChunkPipeline;
import org.spongepowered.common.util.PrettyPrinter;
import org.spongepowered.common.world.BlockChange;
import org.spongepowered.common.world.SpongeBlockChangeFlag;

public final class ChangeBlock
extends BlockEventBasedTransaction {
    public final SpongeBlockSnapshot original;
    final int originalOpacity;
    final net.minecraft.world.level.block.state.BlockState newState;
    final SpongeBlockChangeFlag blockChangeFlag;
    public @Nullable BlockEntity queuedRemoval;
    public @Nullable BlockEntity queuedAdd;

    public ChangeBlock(SpongeBlockSnapshot attachedSnapshot, net.minecraft.world.level.block.state.BlockState newState, SpongeBlockChangeFlag blockChange) {
        super(attachedSnapshot.getBlockPos(), (net.minecraft.world.level.block.state.BlockState)attachedSnapshot.state(), attachedSnapshot.world());
        this.original = attachedSnapshot;
        this.newState = newState;
        this.blockChangeFlag = blockChange;
        this.originalOpacity = this.originalState.getLightBlock((BlockGetter)this.original.getServerWorld().get(), this.affectedPosition);
    }

    public net.minecraft.world.level.block.state.BlockState getNewState() {
        return this.newState;
    }

    public SpongeBlockChangeFlag getBlockChangeFlag() {
        return this.blockChangeFlag;
    }

    public void populateChunkEffects(ChunkPipeline.Builder builder) {
        builder.addEffect(SetBlockToChunkSectionEffect.getInstance());
        builder.addEffect(UpdateHeightMapEffect.getInstance());
        builder.addEffect(UpdateChunkLightManagerEffect.getInstance());
        builder.addEffect(OldBlockOnReplaceEffect.getInstance());
        builder.addEffect(CheckBlockPostPlacementIsSameEffect.getInstance());
        builder.addEffect(RefreshOldTileEntityOnChunkChangeEffect.getInstance());
        builder.addEffect(BlockAddedEffect.getInstance());
        builder.addEffect(UpdateOrCreateNewTileEntityPostPlacementEffect.getInstance());
        builder.addEffect(ChunkChangeCompleteEffect.getInstance());
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", ChangeBlock.class.getSimpleName() + "[", "]").add("affectedPosition=" + this.affectedPosition).add("originalState=" + this.originalState).add("originalOpacity=" + this.originalOpacity).add("newState=" + this.newState).add("blockChangeFlag=" + this.blockChangeFlag).add("queuedRemoval=" + this.queuedRemoval).add("queuedAdd=" + this.queuedAdd).add("worldKey=" + this.worldKey).add("cancelled=" + this.cancelled).toString();
    }

    @Override
    public Optional<BiConsumer<PhaseContext<@NonNull ?>, CauseStackManager.StackFrame>> getFrameMutator(@Nullable GameTransaction<@NonNull ?> parent) {
        return Optional.of(PhaseContext::addCreatorAndNotifierToCauseStack);
    }

    @Override
    public boolean acceptTileAddition(BlockEntity tileEntity) {
        if (this.queuedAdd == tileEntity) {
            return true;
        }
        if (this.queuedAdd != null) {
            return false;
        }
        if (!this.affectedPosition.equals((Object)tileEntity.getBlockPos())) {
            return false;
        }
        this.queuedAdd = tileEntity;
        return true;
    }

    @Override
    public boolean acceptTileRemoval(@Nullable BlockEntity tileentity) {
        if (this.queuedRemoval == tileentity) {
            return true;
        }
        if (this.queuedRemoval != null) {
            return false;
        }
        if (!this.affectedPosition.equals((Object)tileentity.getBlockPos())) {
            return false;
        }
        this.queuedRemoval = tileentity;
        return true;
    }

    @Override
    public boolean acceptTileReplacement(@Nullable BlockEntity existing, BlockEntity proposed) {
        return this.acceptTileRemoval(existing) && this.acceptTileAddition(proposed);
    }

    @Override
    public void restore(PhaseContext<?> context, ChangeBlockEvent.All event) {
        this.original.restore(true, BlockChangeFlagManager.fromNativeInt(314));
    }

    @Override
    public void addToPrinter(PrettyPrinter printer) {
        printer.add("ChangeBlock").add(" %s : %s", "Original Block", this.original).add(" %s : %s", "New State", this.newState).add(" %s : %s", "RemovedTile", this.queuedRemoval).add(" %s : %s", "AddedTile", this.queuedAdd).add(" %s : %s", "ChangeFlag", this.blockChangeFlag);
    }

    @Override
    protected SpongeBlockSnapshot getResultingSnapshot() {
        SpongeBlockSnapshot.BuilderImpl builder = SpongeBlockSnapshot.BuilderImpl.pooled().position(this.original.position()).blockState((BlockState)this.newState);
        if (this.original.getServerWorld().isPresent()) {
            builder.world(this.original.getServerWorld().get());
        } else {
            builder.world(this.original.world());
        }
        return builder.build();
    }

    @Override
    protected SpongeBlockSnapshot getOriginalSnapshot() {
        return this.original;
    }

    @Override
    public boolean absorbBlockDropsPreparation(PhaseContext<@NonNull ?> context, PrepareBlockDropsTransaction transaction) {
        return this.original.blockChange == BlockChange.BREAK && this.affectedPosition.equals((Object)transaction.affectedPosition) && this.original.state() == transaction.getOriginalSnapshot().state();
    }
}

