/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.context.transaction.effect;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.common.bridge.world.level.block.state.BlockStateBridge;
import org.spongepowered.common.event.tracking.context.transaction.effect.EffectResult;
import org.spongepowered.common.event.tracking.context.transaction.effect.ProcessingSideEffect;
import org.spongepowered.common.event.tracking.context.transaction.pipeline.BlockPipeline;
import org.spongepowered.common.event.tracking.context.transaction.pipeline.PipelineCursor;
import org.spongepowered.common.world.SpongeBlockChangeFlag;

public final class UpdateOrCreateNewTileEntityPostPlacementEffect
implements ProcessingSideEffect {
    UpdateOrCreateNewTileEntityPostPlacementEffect() {
    }

    public static UpdateOrCreateNewTileEntityPostPlacementEffect getInstance() {
        return Holder.INSTANCE;
    }

    @Override
    public EffectResult processSideEffect(BlockPipeline pipeline, PipelineCursor oldState, BlockState newState, SpongeBlockChangeFlag flag, int limit) {
        if (((BlockStateBridge)newState).bridge$hasTileEntity()) {
            ServerLevel serverWorld = pipeline.getServerWorld();
            LevelChunk chunk = pipeline.getAffectedChunk();
            @Nullable BlockEntity existing = chunk.getBlockEntity(oldState.pos, LevelChunk.EntityCreationType.CHECK);
            if (existing == null) {
                serverWorld.setBlockEntity(oldState.pos, ((BlockStateBridge)newState).bridge$createTileEntity((Level)serverWorld));
            } else {
                existing.clearCache();
            }
        }
        return EffectResult.NULL_PASS;
    }

    private static final class Holder {
        static final UpdateOrCreateNewTileEntityPostPlacementEffect INSTANCE = new UpdateOrCreateNewTileEntityPostPlacementEffect();

        private Holder() {
        }
    }
}

