/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.context.transaction.inventory;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerClosePacket;
import net.minecraft.network.protocol.game.ClientboundOpenScreenPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.item.inventory.ChangeInventoryEvent;
import org.spongepowered.api.event.item.inventory.container.InteractContainerEvent;
import org.spongepowered.api.item.inventory.Container;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.inventory.transaction.SlotTransaction;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.context.transaction.GameTransaction;
import org.spongepowered.common.event.tracking.context.transaction.inventory.ContainerSlotTransaction;
import org.spongepowered.common.event.tracking.context.transaction.inventory.MenuBasedTransaction;
import org.spongepowered.common.event.tracking.context.transaction.type.TransactionTypes;
import org.spongepowered.common.event.tracking.phase.packet.PacketPhaseUtil;
import org.spongepowered.common.item.util.ItemStackUtil;
import org.spongepowered.common.util.PrettyPrinter;

public class CloseMenuTransaction
extends MenuBasedTransaction<InteractContainerEvent> {
    private final ServerPlayer player;
    private final ItemStackSnapshot cursor;
    private boolean clientSource;
    private @MonotonicNonNull List<SlotTransaction> slotTransactions;

    public CloseMenuTransaction(Player player, boolean clientSource) {
        super(TransactionTypes.INTERACT_CONTAINER_EVENT.get(), player.containerMenu);
        this.player = (ServerPlayer)player;
        this.cursor = ItemStackUtil.snapshotOf(player.inventory.getCarried());
        this.clientSource = clientSource;
    }

    @Override
    public Optional<BiConsumer<PhaseContext<@NonNull ?>, CauseStackManager.StackFrame>> getFrameMutator(@Nullable GameTransaction<@NonNull ?> parent) {
        return Optional.empty();
    }

    @Override
    public Optional<InteractContainerEvent> generateEvent(PhaseContext<@NonNull ?> context, @Nullable GameTransaction<@NonNull ?> parent, ImmutableList<GameTransaction<InteractContainerEvent>> gameTransactions, Cause currentCause) {
        ItemStackSnapshot resultingCursor = ItemStackUtil.snapshotOf(this.player.inventory.getCarried());
        Transaction<ItemStackSnapshot> cursorTransaction = new Transaction<ItemStackSnapshot>(this.cursor, resultingCursor);
        InteractContainerEvent.Close event = SpongeEventFactory.createInteractContainerEventClose(currentCause, (Container)this.menu, cursorTransaction, (Container)this.menu, this.slotTransactions == null ? Collections.emptyList() : this.slotTransactions);
        return Optional.of(event);
    }

    @Override
    public void restore(PhaseContext<@NonNull ?> context, InteractContainerEvent event) {
        if (this.clientSource) {
            this.reopen(this.player, this.menu);
        }
        PacketPhaseUtil.handleCursorRestore((Player)this.player, event.cursorTransaction(), event.isCancelled());
        if (event instanceof ChangeInventoryEvent) {
            PacketPhaseUtil.handleSlotRestore((Player)this.player, this.menu, ((ChangeInventoryEvent)((Object)event)).transactions(), event.isCancelled());
        }
        this.player.inventoryMenu.broadcastChanges();
    }

    @Override
    public boolean absorbSlotTransaction(ContainerSlotTransaction slotTransaction) {
        if (this.menu != slotTransaction.menu) {
            return this.player.inventoryMenu == slotTransaction.menu;
        }
        if (this.slotTransactions == null) {
            this.slotTransactions = new ArrayList<SlotTransaction>();
        }
        this.slotTransactions.add(slotTransaction.transaction);
        return true;
    }

    @Override
    public void postProcessEvent(PhaseContext<@NonNull ?> context, InteractContainerEvent event) {
        if (!this.clientSource) {
            this.player.connection.send((Packet)new ClientboundContainerClosePacket(this.player.containerMenu.containerId));
        }
        this.player.containerMenu = this.player.inventoryMenu;
        PacketPhaseUtil.handleCursorRestore((Player)this.player, event.cursorTransaction(), event.isCancelled());
        if (event instanceof ChangeInventoryEvent) {
            PacketPhaseUtil.handleSlotRestore((Player)this.player, this.menu, ((ChangeInventoryEvent)((Object)event)).transactions(), event.isCancelled());
        }
        this.player.inventoryMenu.broadcastChanges();
    }

    @Override
    public boolean markCancelledTransactions(InteractContainerEvent event, ImmutableList<? extends GameTransaction<InteractContainerEvent>> gameTransactions) {
        if (event.isCancelled()) {
            event.cursorTransaction().invalidate();
            return true;
        }
        return !event.cursorTransaction().isValid();
    }

    @Override
    public void addToPrinter(PrettyPrinter printer) {
    }

    private void reopen(ServerPlayer player, AbstractContainerMenu container) {
        if (container.getSlot(0) == null) {
            return;
        }
        if (!(container instanceof InventoryMenu)) {
            player.containerMenu = container;
            Slot slot = container.getSlot(0);
            net.minecraft.world.Container slotInventory = slot.container;
            Component title = slotInventory instanceof MenuProvider ? ((MenuProvider)slotInventory).getDisplayName() : null;
            slotInventory.startOpen((Player)player);
            player.connection.send((Packet)new ClientboundOpenScreenPacket(container.containerId, container.getType(), title));
            player.refreshContainer(container);
        }
    }
}

