/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.context.transaction.pipeline;

import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.world.BlockChangeFlags;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.context.transaction.EffectTransactor;
import org.spongepowered.common.event.tracking.context.transaction.ResultingTransactionBySideEffect;
import org.spongepowered.common.event.tracking.context.transaction.effect.EffectResult;
import org.spongepowered.common.event.tracking.context.transaction.effect.ProcessingSideEffect;
import org.spongepowered.common.event.tracking.context.transaction.pipeline.BlockPipeline;
import org.spongepowered.common.event.tracking.context.transaction.pipeline.PipelineCursor;
import org.spongepowered.common.world.SpongeBlockChangeFlag;

public final class TileEntityPipeline
implements BlockPipeline {
    private final @Nullable Supplier<LevelChunk> chunkSupplier;
    private final @Nullable Supplier<ServerLevel> serverWorld;
    private final @Nullable Supplier<LevelChunkSection> sectionSupplier;
    private final List<ResultingTransactionBySideEffect> effects;

    private TileEntityPipeline(Builder builder) {
        this.chunkSupplier = builder.chunkSupplier;
        this.serverWorld = builder.serverWorld;
        this.sectionSupplier = builder.sectionSupplier;
        this.effects = builder.effects;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder kickOff(ServerLevel world, BlockPos pos) {
        WeakReference<ServerLevel> worldRef = new WeakReference<ServerLevel>(world);
        LevelChunk chunk = world.getChunkAt(pos);
        WeakReference<LevelChunk> chunkRef = new WeakReference<LevelChunk>(chunk);
        WeakReference<LevelChunkSection> sectionRef = new WeakReference<LevelChunkSection>(chunk.getSections()[pos.getY() >> 4]);
        Supplier<ServerLevel> worldSupplier = () -> Objects.requireNonNull((ServerLevel)worldRef.get(), "ServerWorld de-referenced");
        Supplier<LevelChunk> chunkSupplier = () -> Objects.requireNonNull((LevelChunk)chunkRef.get(), "Chunk de-referenced");
        Supplier<LevelChunkSection> chunkSectionSupplier = () -> Objects.requireNonNull((LevelChunkSection)sectionRef.get(), "ChunkSection de-referenced");
        return TileEntityPipeline.builder().chunk(chunkSupplier).world(worldSupplier).chunkSection(chunkSectionSupplier);
    }

    @Override
    public ServerLevel getServerWorld() {
        return Objects.requireNonNull(this.serverWorld, "ServerWorld Supplier is null in TileEntityPipeline").get();
    }

    @Override
    public LevelChunk getAffectedChunk() {
        return Objects.requireNonNull(this.chunkSupplier, "Chunk Supplier is null in TileEntityPipeline").get();
    }

    @Override
    public LevelChunkSection getAffectedSection() {
        return Objects.requireNonNull(this.sectionSupplier, "ChunkSection Supplier is null in TileEntityPipeline").get();
    }

    @Override
    public boolean wasEmpty() {
        return false;
    }

    public boolean processEffects(PhaseContext<?> context, PipelineCursor initialCursor) {
        PipelineCursor currentCursor = initialCursor;
        for (ResultingTransactionBySideEffect effect : this.effects) {
            EffectTransactor ignored = context.getTransactor().pushEffect(effect);
            try {
                EffectResult result = effect.effect.processSideEffect(this, currentCursor, currentCursor.state, (SpongeBlockChangeFlag)BlockChangeFlags.NONE, currentCursor.limit);
                if (result.resultingState != currentCursor.state) {
                    currentCursor = new PipelineCursor(result.resultingState, currentCursor.light, currentCursor.opacity, currentCursor.pos, currentCursor.tileEntity, currentCursor.destroyer, currentCursor.limit);
                }
                if (!result.hasResult) continue;
                boolean bl = result.resultingState != null;
                return bl;
            }
            finally {
                if (ignored == null) continue;
                ignored.close();
            }
        }
        return false;
    }

    public static final class Builder {
        @Nullable Supplier<ServerLevel> serverWorld;
        @Nullable Supplier<LevelChunk> chunkSupplier;
        @Nullable Supplier<LevelChunkSection> sectionSupplier;
        List<ResultingTransactionBySideEffect> effects;

        public Builder addEffect(ProcessingSideEffect effect) {
            if (this.effects == null) {
                this.effects = new LinkedList<ResultingTransactionBySideEffect>();
            }
            this.effects.add(new ResultingTransactionBySideEffect(Objects.requireNonNull(effect, "Effect is null")));
            return this;
        }

        public Builder chunk(Supplier<LevelChunk> chunk) {
            this.chunkSupplier = chunk;
            return this;
        }

        public Builder chunkSection(Supplier<LevelChunkSection> section) {
            this.sectionSupplier = section;
            return this;
        }

        public Builder world(Supplier<ServerLevel> world) {
            this.serverWorld = world;
            return this;
        }

        public TileEntityPipeline build() {
            if (this.effects == null) {
                this.effects = Collections.emptyList();
            }
            Objects.requireNonNull(this.serverWorld, "ServerWorld must have been recorded!");
            Objects.requireNonNull(this.chunkSupplier, "Chunk must have been recorded!");
            return new TileEntityPipeline(this);
        }
    }
}

