/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.context.transaction.type;

import java.util.Collection;
import java.util.Objects;
import java.util.StringJoiner;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.event.Event;
import org.spongepowered.common.event.tracking.PhaseContext;

public abstract class TransactionType<E extends Event> {
    private final boolean isPrimary;
    private final String name;
    protected final Marker marker;

    TransactionType(boolean isPrimary, String name) {
        this.isPrimary = isPrimary;
        this.name = name;
        this.marker = MarkerManager.getMarker((String)this.name);
    }

    public boolean isPrimary() {
        return this.isPrimary;
    }

    public boolean isSecondary() {
        return !this.isPrimary;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return new StringJoiner(", ", TransactionType.class.getSimpleName() + "[", "]").add("isPrimary=" + this.isPrimary).add("name='" + this.name + "'").toString();
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransactionType that = (TransactionType)o;
        return this.isPrimary == that.isPrimary && this.name.equals(that.name);
    }

    public int hashCode() {
        return Objects.hash(this.isPrimary, this.name);
    }

    public void createAndProcessPostEvents(PhaseContext<@NonNull ?> context, Collection<? extends E> events) {
        this.consumeEventsAndMarker(context, events);
    }

    protected void consumeEventsAndMarker(PhaseContext<@NonNull ?> context, Collection<? extends E> events) {
    }
}

