/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.inventory.util;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.CompoundContainer;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.BeaconMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.item.inventory.BlockCarrier;
import org.spongepowered.api.item.inventory.Carrier;
import org.spongepowered.api.item.inventory.Container;
import org.spongepowered.api.item.inventory.type.CarriedInventory;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.accessor.world.inventory.AbstractContainerMenuAccessor;
import org.spongepowered.common.accessor.world.inventory.AbstractFurnaceMenuAccessor;
import org.spongepowered.common.accessor.world.inventory.BeaconMenuAccessor;
import org.spongepowered.common.accessor.world.inventory.BrewingStandMenuAccessor;
import org.spongepowered.common.accessor.world.inventory.DispenserMenuAccessor;
import org.spongepowered.common.accessor.world.inventory.HopperMenuAccessor;
import org.spongepowered.common.accessor.world.inventory.HorseInventoryMenuAccessor;
import org.spongepowered.common.accessor.world.inventory.ItemCombinerMenuAccessor;
import org.spongepowered.common.accessor.world.inventory.MerchantMenuAccessor;
import org.spongepowered.common.accessor.world.inventory.ResultSlotAccessor;
import org.spongepowered.common.bridge.world.inventory.InventoryBridge;
import org.spongepowered.common.bridge.world.inventory.container.ContainerBridge;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.inventory.SpongeBlockEntityCarrier;
import org.spongepowered.common.inventory.SpongeLocationCarrier;
import org.spongepowered.common.inventory.custom.CustomContainer;
import org.spongepowered.common.inventory.lens.CompoundSlotLensProvider;
import org.spongepowered.common.inventory.lens.Lens;
import org.spongepowered.common.inventory.lens.impl.CompoundLens;
import org.spongepowered.common.inventory.lens.impl.DelegatingLens;
import org.spongepowered.common.inventory.lens.impl.comp.CraftingInventoryLens;
import org.spongepowered.common.inventory.lens.impl.comp.GridInventoryLens;
import org.spongepowered.common.inventory.lens.impl.comp.PrimaryPlayerInventoryLens;
import org.spongepowered.common.inventory.lens.impl.minecraft.PlayerInventoryLens;
import org.spongepowered.common.inventory.lens.impl.minecraft.SingleGridLens;
import org.spongepowered.common.inventory.lens.impl.minecraft.container.ContainerLens;
import org.spongepowered.common.inventory.lens.impl.slot.SlotLensProvider;

public final class ContainerUtil {
    private static final Random RANDOM = new Random();

    private ContainerUtil() {
    }

    public static Container fromNative(AbstractContainerMenu container) {
        return (Container)container;
    }

    public static AbstractContainerMenu toNative(Container container) {
        return (AbstractContainerMenu)container;
    }

    public static void performBlockInventoryDrops(ServerLevel worldServer, double x, double y, double z, net.minecraft.world.Container inventory) {
        PhaseContext<@NonNull ?> context = PhaseTracker.getInstance().getPhaseContext();
        if (context.doesBlockEventTracking()) {
            for (int j = 0; j < inventory.getContainerSize(); ++j) {
                ItemStack itemStack = inventory.getItem(j);
                if (itemStack.isEmpty()) continue;
                float f = RANDOM.nextFloat() * 0.8f + 0.1f;
                float f1 = RANDOM.nextFloat() * 0.8f + 0.1f;
                float f2 = RANDOM.nextFloat() * 0.8f + 0.1f;
                while (!itemStack.isEmpty()) {
                    int i = RANDOM.nextInt(21) + 10;
                    ItemEntity entityitem = new ItemEntity((Level)worldServer, x + (double)f, y + (double)f1, z + (double)f2, itemStack.split(i));
                    entityitem.setDeltaMovement(RANDOM.nextGaussian() * 0.05, RANDOM.nextGaussian() * 0.05 + 0.2, RANDOM.nextGaussian() * 0.05);
                    worldServer.addFreshEntity((Entity)entityitem);
                }
            }
            return;
        }
        for (int i = 0; i < inventory.getContainerSize(); ++i) {
            ItemStack itemStack = inventory.getItem(i);
            if (itemStack.isEmpty()) continue;
            Containers.dropItemStack((Level)worldServer, (double)x, (double)y, (double)z, (ItemStack)itemStack);
        }
    }

    public static Lens generateLens(AbstractContainerMenu container, SlotLensProvider slots) {
        Map viewed = container.slots.stream().collect(Collectors.groupingBy(i -> Optional.ofNullable(i.container), LinkedHashMap::new, Collectors.toList()));
        int index = 0;
        CraftingInventoryData crafting = new CraftingInventoryData();
        int chestHeight = 0;
        ArrayList<Lens> lenses = new ArrayList<Lens>();
        for (Map.Entry entry : viewed.entrySet()) {
            List slotList = (List)entry.getValue();
            int slotCount = slotList.size();
            net.minecraft.world.Container subInventory = ((Optional)entry.getKey()).orElse(null);
            Lens lens = ContainerUtil.generateAdapterLens(slots, index, crafting, slotList, subInventory);
            if (lens.slotCount() != slotCount) {
                CompoundSlotLensProvider slotProvider = new CompoundSlotLensProvider().add(((InventoryBridge)subInventory).bridge$getAdapter());
                CompoundLens.Builder lensBuilder = CompoundLens.builder();
                for (Slot slot : slotList) {
                    lensBuilder.add(((InventoryBridge)slot).bridge$getAdapter().inventoryAdapter$getRootLens());
                }
                lens = lensBuilder.build(slotProvider);
            }
            lenses.add(lens);
            index += slotCount;
            if (chestHeight == -1) continue;
            if (lens instanceof DelegatingLens) {
                Lens delegated = ((DelegatingLens)lens).getDelegate();
                if (delegated instanceof PrimaryPlayerInventoryLens) {
                    delegated = ((PrimaryPlayerInventoryLens)delegated).getFullGrid();
                }
                if (delegated instanceof SingleGridLens) {
                    delegated = delegated.getSpanningChildren().get(0);
                }
                if (delegated instanceof GridInventoryLens) {
                    if (((GridInventoryLens)delegated).getWidth() == 9) {
                        chestHeight += ((GridInventoryLens)delegated).getHeight();
                        continue;
                    }
                    chestHeight = -1;
                    continue;
                }
                chestHeight = -1;
                continue;
            }
            chestHeight = -1;
        }
        ArrayList<Lens> additional = new ArrayList<Lens>();
        try {
            if (crafting.out != null && crafting.base != null && crafting.grid != null) {
                additional.add(new CraftingInventoryLens((int)crafting.out, (int)crafting.base, crafting.grid.getWidth(), crafting.grid.getHeight(), slots));
            } else if (crafting.base != null && crafting.grid != null) {
                additional.add(new GridInventoryLens(crafting.base, crafting.grid.getWidth(), crafting.grid.getHeight(), slots));
            }
        }
        catch (Exception e) {
            SpongeCommon.logger().error("Error while creating CraftingInventoryLensImpl or GridInventoryLensImpl for " + container.getClass().getName(), (Throwable)e);
        }
        if (chestHeight > 0) {
            additional.add(new GridInventoryLens(0, 9, chestHeight, slots));
        }
        return new ContainerLens(container.slots.size(), container.getClass(), slots, lenses, additional);
    }

    private static Lens generateAdapterLens(SlotLensProvider slots, int index, CraftingInventoryData crafting, List<Slot> slotList, @Nullable net.minecraft.world.Container subInventory) {
        Slot slot;
        Lens lens = ((InventoryBridge)subInventory).bridge$getAdapter().inventoryAdapter$getRootLens();
        if (lens instanceof PlayerInventoryLens) {
            if (slotList.size() == 36) {
                return new DelegatingLens(index, new PrimaryPlayerInventoryLens(0, slots, true), slots);
            }
            return lens;
        }
        if (subInventory instanceof ResultContainer && (slot = slotList.get(0)) instanceof ResultSlotAccessor) {
            crafting.out = index;
            if (crafting.base == null) {
                crafting.base = index + 1;
                crafting.grid = ((ResultSlotAccessor)slot).accessor$craftSlots();
            }
        }
        if (subInventory instanceof CraftingContainer) {
            crafting.base = index;
            crafting.grid = (CraftingContainer)subInventory;
        }
        return new DelegatingLens(index, slotList, lens, slots);
    }

    public static @Nullable Carrier getCarrier(Container container) {
        ServerLocation loc;
        Object player;
        if (container instanceof BlockCarrier) {
            return (BlockCarrier)((Object)container);
        }
        if (container instanceof CustomContainer) {
            return ((CustomContainer)((Object)container)).inv.getCarrier();
        }
        if (container instanceof ChestMenu) {
            net.minecraft.world.Container inventory = ((ChestMenu)container).getContainer();
            if (inventory instanceof Carrier) {
                if (inventory instanceof ChestBlockEntity) {
                    return (Carrier)inventory;
                }
                if (inventory instanceof CompoundContainer) {
                    return (BlockCarrier)inventory;
                }
            }
            return ContainerUtil.carrierOrNull(inventory);
        }
        if (container instanceof HopperMenuAccessor) {
            return ContainerUtil.carrierOrNull(((HopperMenuAccessor)((Object)container)).accessor$hopper());
        }
        if (container instanceof DispenserMenuAccessor) {
            return ContainerUtil.carrierOrNull(((DispenserMenuAccessor)((Object)container)).accessor$dispenser());
        }
        if (container instanceof AbstractFurnaceMenuAccessor) {
            return ContainerUtil.carrierOrNull(((AbstractFurnaceMenuAccessor)((Object)container)).accessor$container());
        }
        if (container instanceof BrewingStandMenuAccessor) {
            return ContainerUtil.carrierOrNull(((BrewingStandMenuAccessor)((Object)container)).accessor$brewingStand());
        }
        if (container instanceof BeaconMenu) {
            return new SpongeBlockEntityCarrier(((BeaconMenuAccessor)((Object)container)).accessor$access().evaluate(Level::getBlockEntity).orElse(null), container);
        }
        if (container instanceof HorseInventoryMenuAccessor) {
            return (Carrier)((HorseInventoryMenuAccessor)((Object)container)).accessor$horse();
        }
        if (container instanceof MerchantMenuAccessor && ((MerchantMenuAccessor)((Object)container)).accessor$trader() instanceof Carrier) {
            return (Carrier)((MerchantMenuAccessor)((Object)container)).accessor$trader();
        }
        if (container instanceof ItemCombinerMenuAccessor && (player = ((ItemCombinerMenuAccessor)((Object)container)).accessor$player()) instanceof ServerPlayer) {
            return (Carrier)player;
        }
        if (container instanceof AbstractContainerMenuAccessor) {
            for (Slot slot : ((AbstractContainerMenuAccessor)((Object)container)).accessor$slots()) {
                if (slot.container instanceof Carrier) {
                    return (Carrier)slot.container;
                }
                if (!(slot.container instanceof BlockEntity)) continue;
                return new SpongeBlockEntityCarrier((BlockEntity)slot.container, container);
            }
        }
        if ((loc = ((ContainerBridge)((Object)container)).bridge$getOpenLocation()) != null) {
            return new SpongeLocationCarrier(loc, container);
        }
        return null;
    }

    private static Carrier carrierOrNull(net.minecraft.world.Container inventory) {
        if (inventory instanceof Carrier) {
            return (Carrier)inventory;
        }
        if (inventory instanceof CarriedInventory) {
            Optional carrier = ((CarriedInventory)inventory).carrier();
            return carrier.orElse(null);
        }
        return null;
    }

    private static class CraftingInventoryData {
        private @Nullable Integer out;
        private @Nullable Integer base;
        private @Nullable CraftingContainer grid;

        private CraftingInventoryData() {
        }
    }
}

