/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.map;

import com.google.common.collect.BiMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.maps.MapIndex;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.map.MapInfo;
import org.spongepowered.api.map.MapStorage;
import org.spongepowered.api.world.DefaultWorldKeys;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.bridge.map.MapIdTrackerBridge;
import org.spongepowered.common.bridge.world.level.storage.PrimaryLevelDataBridge;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.PhaseTracker;

public final class SpongeMapStorage
implements MapStorage {
    private final Map<UUID, MapInfo> loadedMapUUIDs = new HashMap<UUID, MapInfo>();
    private @Nullable BiMap<Integer, UUID> mapIdUUIDIndex = null;

    @Override
    public Collection<MapInfo> allMapInfos() {
        HashSet<MapInfo> mapInfos = new HashSet<MapInfo>();
        ServerLevel defaultWorld = (ServerLevel)Sponge.server().worldManager().world(DefaultWorldKeys.DEFAULT).get();
        int highestId = ((MapIdTrackerBridge)defaultWorld.getDataStorage().computeIfAbsent(MapIndex::new, "idcounts")).bridge$getHighestMapId().orElse(-1);
        for (int i = 0; i <= highestId; ++i) {
            @Nullable MapInfo mapInfo = (MapInfo)defaultWorld.getMapData("map_" + i);
            if (mapInfo == null) {
                SpongeCommon.logger().warn("Missing map with id: " + i);
                continue;
            }
            this.addMapInfo(mapInfo);
            mapInfos.add(mapInfo);
        }
        return mapInfos;
    }

    @Override
    public Optional<MapInfo> mapInfo(UUID uuid) {
        this.ensureHasMapUUIDIndex();
        MapInfo mapInfo = this.loadedMapUUIDs.get(uuid);
        if (mapInfo != null) {
            return Optional.of(mapInfo);
        }
        Integer mapId = (Integer)this.mapIdUUIDIndex.inverse().get((Object)uuid);
        if (mapId == null) {
            return Optional.empty();
        }
        ServerLevel defaultWorld = (ServerLevel)Sponge.server().worldManager().world(DefaultWorldKeys.DEFAULT).get();
        MapInfo loadedMapInfo = (MapInfo)defaultWorld.getMapData("map_" + mapId);
        return Optional.ofNullable(loadedMapInfo);
    }

    @Override
    public Optional<MapInfo> createNewMapInfo() {
        return SpongeCommonEventFactory.fireCreateMapEvent(PhaseTracker.getCauseStackManager().currentCause());
    }

    public UUID requestUUID(int id) {
        this.ensureHasMapUUIDIndex();
        UUID uuid = (UUID)this.mapIdUUIDIndex.get((Object)id);
        if (uuid == null) {
            uuid = UUID.randomUUID();
            this.mapIdUUIDIndex.put((Object)id, (Object)uuid);
        }
        return uuid;
    }

    public void addMapInfo(MapInfo mapInfo) {
        this.loadedMapUUIDs.put(mapInfo.uniqueId(), mapInfo);
    }

    private void ensureHasMapUUIDIndex() {
        if (this.mapIdUUIDIndex == null) {
            this.mapIdUUIDIndex = ((PrimaryLevelDataBridge)((Object)Sponge.server().worldManager().world(DefaultWorldKeys.DEFAULT).get().properties())).bridge$getMapUUIDIndex();
        }
    }
}

