/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.map.canvas;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.map.MapCanvas;
import org.spongepowered.api.map.color.MapColor;
import org.spongepowered.api.map.color.MapColorType;
import org.spongepowered.api.map.color.MapShade;
import org.spongepowered.api.registry.RegistryTypes;
import org.spongepowered.common.map.canvas.SpongeEmptyCanvas;
import org.spongepowered.common.map.canvas.SpongeMapByteCanvas;
import org.spongepowered.common.map.color.SpongeMapColor;
import org.spongepowered.common.util.Constants;
import org.spongepowered.common.util.MapUtil;

public final class SpongeMapCanvasBuilder
implements MapCanvas.Builder {
    private byte @Nullable [] canvas = null;

    private byte[] getCanvas() {
        if (this.canvas == null) {
            this.canvas = new byte[16384];
        }
        return this.canvas;
    }

    @Override
    public MapCanvas.Builder paintAll(MapColor color) {
        Arrays.fill(this.getCanvas(), ((SpongeMapColor)color).getMCColor());
        return this;
    }

    @Override
    public MapCanvas.Builder paint(int startX, int startY, int endX, int endY, MapColor mapColor) {
        if (!MapUtil.isInCanvasBounds(startX)) {
            throw new IllegalStateException("startX out of bounds");
        }
        if (!MapUtil.isInCanvasBounds(startY)) {
            throw new IllegalStateException("startY out of bounds");
        }
        if (!MapUtil.isInCanvasBounds(endX)) {
            throw new IllegalStateException("endX out of bounds");
        }
        if (!MapUtil.isInCanvasBounds(endY)) {
            throw new IllegalStateException("endY out of bounds");
        }
        byte[] canvas = this.getCanvas();
        byte color = ((SpongeMapColor)mapColor).getMCColor();
        for (int x = startX; x <= endX; ++x) {
            for (int y = startY; y <= endY; ++y) {
                canvas[x + y * 128] = color;
            }
        }
        return this;
    }

    @Override
    public MapCanvas.Builder from(MapCanvas canvas) {
        if (canvas instanceof SpongeEmptyCanvas) {
            return MapCanvas.builder();
        }
        this.canvas = (byte[])((SpongeMapByteCanvas)canvas).canvas.clone();
        return this;
    }

    @Override
    public MapCanvas.Builder reset() {
        this.canvas = null;
        return this;
    }

    @Override
    public MapCanvas.Builder fromImage(Image image) {
        Objects.requireNonNull(image, "image cannot be null");
        if (image.getWidth(null) != 128 || image.getHeight(null) != 128) {
            throw new IllegalArgumentException("image size was invalid!");
        }
        BufferedImage bufferedImage = this.createBufferedImage(image);
        int[] pixels = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
        HashMap palette = new HashMap();
        Sponge.game().registry(RegistryTypes.MAP_COLOR_TYPE).stream().forEach(color -> Sponge.game().registry(RegistryTypes.MAP_SHADE).stream().forEach(shade -> {
            SpongeMapColor spongeMapColor = new SpongeMapColor((MapColorType)color, (MapShade)shade);
            palette.put(spongeMapColor.color().rgb(), spongeMapColor);
        }));
        byte[] canvas = this.getCanvas();
        for (int i = 0; i < pixels.length; ++i) {
            SpongeMapColor color2 = (SpongeMapColor)palette.get(pixels[i]);
            if (color2 == null) {
                throw new IllegalArgumentException("Can not find a matching color for rgb value: " + Integer.toHexString(pixels[i]) + ". The MapCanvas will have painted all pixels up to this point.");
            }
            canvas[i] = color2.getMCColor();
        }
        return this;
    }

    @Override
    public MapCanvas.Builder fromContainer(DataView container) {
        Objects.requireNonNull(container, "container cannot be null");
        if (!container.contains(Constants.Map.MAP_CANVAS)) {
            return this;
        }
        this.reset();
        this.canvas = MapUtil.getMapCanvasFromContainer(container);
        return this;
    }

    @Override
    public MapCanvas build() {
        if (this.canvas == null) {
            return SpongeEmptyCanvas.INSTANCE;
        }
        return new SpongeMapByteCanvas((byte[])this.canvas.clone());
    }

    private BufferedImage createBufferedImage(Image image) {
        BufferedImage bufferedImage;
        if (image instanceof BufferedImage && (bufferedImage = (BufferedImage)image).getType() == 1) {
            return bufferedImage;
        }
        bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 1);
        Graphics2D bGr = bufferedImage.createGraphics();
        bGr.drawImage(image, 0, 0, null);
        bGr.dispose();
        return bufferedImage;
    }
}

