/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.minecraft.world.level.block.state;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.data.persistence.Queries;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.api.util.Direction;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.common.block.BlockStateSerializerDeserializer;
import org.spongepowered.common.block.SpongeBlockSnapshot;
import org.spongepowered.common.bridge.data.SpongeDataHolderBridge;
import org.spongepowered.common.bridge.world.level.block.state.BlockStateBridge;
import org.spongepowered.common.mixin.api.minecraft.world.level.block.state.BlockBehaviour_BlockStateBaseMixin_API;
import org.spongepowered.common.util.Constants;

@Mixin(value={net.minecraft.world.level.block.state.BlockState.class})
public abstract class BlockStateMixin_API
extends BlockBehaviour_BlockStateBaseMixin_API {
    private String api$serializedState;

    @Override
    public int contentVersion() {
        return 2;
    }

    @Override
    public DataContainer toContainer() {
        return DataContainer.createNew().set(Queries.CONTENT_VERSION, this.contentVersion()).set(Constants.Block.BLOCK_STATE, this.asString());
    }

    @Override
    public BlockSnapshot snapshotFor(ServerLocation location) {
        SpongeBlockSnapshot.BuilderImpl builder = SpongeBlockSnapshot.BuilderImpl.pooled().blockState((net.minecraft.world.level.block.state.BlockState)this).position(location.blockPosition()).world((ServerLevel)location.world());
        if (((BlockStateBridge)((Object)this)).bridge$hasTileEntity() && location.block().type().equals(this.shadow$getBlock())) {
            org.spongepowered.api.block.entity.BlockEntity tileEntity = location.blockEntity().orElseThrow(() -> new IllegalStateException("Unable to retrieve a TileEntity for location: " + location));
            builder.add(((SpongeDataHolderBridge)((Object)tileEntity)).bridge$getManipulator());
            CompoundTag compound = new CompoundTag();
            ((BlockEntity)tileEntity).save(compound);
            builder.addUnsafeCompound(compound);
        }
        return builder.build();
    }

    @Override
    public boolean validateRawData(DataView container) {
        return container.contains(Constants.Block.BLOCK_STATE);
    }

    @Override
    public <E> Optional<E> get(Direction direction, Key<? extends Value<E>> key) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public BlockState withRawData(DataView container) throws InvalidDataException {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public BlockState copy() {
        return this;
    }

    @Override
    public String asString() {
        if (this.api$serializedState == null) {
            this.api$serializedState = BlockStateSerializerDeserializer.serialize(this);
        }
        return this.api$serializedState;
    }

    @Override
    public List<DataHolder> impl$delegateDataHolder() {
        return Arrays.asList(this, this.type());
    }
}

