/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.minecraft.world.level.chunk;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.ChunkBiomeContainer;
import net.minecraft.world.level.chunk.ProtoChunk;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.util.PositionOutOfBoundsException;
import org.spongepowered.api.world.biome.Biome;
import org.spongepowered.api.world.generation.GenerationChunk;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.api.world.volume.stream.StreamOptions;
import org.spongepowered.api.world.volume.stream.VolumeStream;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.data.holder.SpongeLocationBaseDataHolder;
import org.spongepowered.common.util.Constants;
import org.spongepowered.common.util.MissingImplementationException;
import org.spongepowered.common.world.storage.SpongeChunkLayout;
import org.spongepowered.math.vector.Vector3i;
import org.spongepowered.math.vector.Vectori;

@Mixin(value={ProtoChunk.class})
public abstract class ProtoChunkMixin_API
implements GenerationChunk,
SpongeLocationBaseDataHolder {
    @Shadow
    @Nullable
    private ChunkBiomeContainer biomes;
    private @org.checkerframework.checker.nullness.qual.Nullable Vector3i api$blockMin;
    private @org.checkerframework.checker.nullness.qual.Nullable Vector3i api$blockMax;

    @Shadow
    @Nullable
    public abstract net.minecraft.world.level.block.state.BlockState shadow$setBlockState(BlockPos var1, net.minecraft.world.level.block.state.BlockState var2, boolean var3);

    @Shadow
    public abstract Map<BlockPos, BlockEntity> shadow$getBlockEntities();

    @Shadow
    public abstract void shadow$setBlockEntity(BlockPos var1, BlockEntity var2);

    @Shadow
    public abstract void shadow$removeBlockEntity(BlockPos var1);

    @Override
    public VolumeStream<GenerationChunk, Biome> biomeStream(Vector3i min, Vector3i max, StreamOptions options) {
        throw new UnsupportedOperationException("Cannot stream biomes on ProtoChunk");
    }

    @Override
    public VolumeStream<GenerationChunk, BlockState> blockStateStream(Vector3i min, Vector3i max, StreamOptions options) {
        throw new UnsupportedOperationException("Cannot stream block states on ProtoChunk");
    }

    @Override
    public VolumeStream<GenerationChunk, org.spongepowered.api.block.entity.BlockEntity> blockEntityStream(Vector3i min, Vector3i max, StreamOptions options) {
        throw new UnsupportedOperationException("Cannot stream block entities on ProtoChunk");
    }

    @Override
    public Vector3i min() {
        if (this.api$blockMin == null) {
            this.api$blockMin = SpongeChunkLayout.INSTANCE.forceToWorld(this.chunkPosition());
        }
        return this.api$blockMin;
    }

    @Override
    public Vector3i max() {
        if (this.api$blockMax == null) {
            this.api$blockMax = this.min().add(SpongeChunkLayout.CHUNK_SIZE).sub(1, 1, 1);
        }
        return this.api$blockMax;
    }

    @Override
    public boolean setBlock(int x, int y, int z, BlockState block) {
        return false;
    }

    @Override
    public boolean removeBlock(int x, int y, int z) {
        return false;
    }

    @Override
    public Collection<? extends org.spongepowered.api.block.entity.BlockEntity> blockEntities() {
        return Collections.unmodifiableCollection(this.shadow$getBlockEntities().values());
    }

    @Override
    public void addBlockEntity(int x, int y, int z, org.spongepowered.api.block.entity.BlockEntity blockEntity) {
        this.shadow$setBlockEntity(new BlockPos(x, y, z), (BlockEntity)blockEntity);
    }

    @Override
    public void removeBlockEntity(int x, int y, int z) {
        this.shadow$removeBlockEntity(new BlockPos(x, y, z));
    }

    @Override
    public Biome biome(int x, int y, int z) {
        if (!this.contains(x, y, z)) {
            throw new PositionOutOfBoundsException((Vectori)new Vector3i(x, y, z), (Vectori)Constants.World.BLOCK_MIN, (Vectori)Constants.World.BLOCK_MAX);
        }
        if (this.biomes != null) {
            return (Biome)this.biomes.getNoiseBiome(x, y, z);
        }
        return null;
    }

    @Override
    public ServerLocation impl$dataholder(int x, int y, int z) {
        throw new MissingImplementationException("ProtoChunk", "impl$dataholder");
    }
}

