/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.minecraft.world.level.saveddata;

import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.saveddata.maps.MapDecoration;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.map.MapInfo;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.bridge.data.DataCompoundHolder;
import org.spongepowered.common.bridge.data.SpongeDataHolderBridge;
import org.spongepowered.common.bridge.world.storage.MapDecorationBridge;
import org.spongepowered.common.bridge.world.storage.MapItemSavedDataBridge;
import org.spongepowered.common.map.SpongeMapStorage;

@Mixin(value={MapItemSavedData.class})
public abstract class MapItemSavedDataMixin
extends SavedData
implements MapItemSavedDataBridge,
DataCompoundHolder {
    @Final
    @Shadow
    public Map<String, MapDecoration> decorations;
    private int impl$mapId;
    private UUID impl$uuid;
    private CompoundTag impl$nbt;

    @Shadow
    public abstract void shadow$setDirty(int var1, int var2);

    public MapItemSavedDataMixin(String name) {
        super(name);
    }

    @Override
    public void bridge$updateWholeMap() {
        this.shadow$setDirty(0, 0);
        this.shadow$setDirty(127, 127);
    }

    @Override
    public void bridge$setDecorations(Set<org.spongepowered.api.map.decoration.MapDecoration> newDecorations) {
        this.decorations.clear();
        for (org.spongepowered.api.map.decoration.MapDecoration decoration : newDecorations) {
            this.impl$addDecorationToDecorationsMapIfNotExists((MapDecoration)decoration);
        }
        for (MapDecoration existingDecoration : this.decorations.values()) {
            if (newDecorations.contains(existingDecoration)) continue;
            ((MapDecorationBridge)existingDecoration).notifyRemovedFromMap((MapInfo)((Object)this));
            this.setDirty();
        }
        if (newDecorations.isEmpty()) {
            ((SpongeDataHolderBridge)((Object)this)).bridge$remove(Keys.MAP_DECORATIONS);
        } else {
            ((SpongeDataHolderBridge)((Object)this)).bridge$offer(Keys.MAP_DECORATIONS, newDecorations);
        }
    }

    @Override
    public Set<org.spongepowered.api.map.decoration.MapDecoration> bridge$getDecorations() {
        return this.decorations.values().stream().map(mapDecoration -> (org.spongepowered.api.map.decoration.MapDecoration)mapDecoration).collect(Collectors.toSet());
    }

    @Override
    public int bridge$getMapId() {
        return this.impl$mapId;
    }

    @Override
    public void bridge$setMapId(int mapId) {
        this.impl$mapId = mapId;
    }

    @Override
    @Nonnull
    public UUID bridge$getUniqueId() {
        return this.impl$uuid;
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    public void impl$setMapId(String mapname, CallbackInfo ci) {
        int underscore = mapname.lastIndexOf(95);
        if (underscore != -1) {
            String id = mapname.substring(underscore + 1);
            try {
                this.impl$mapId = Integer.parseInt(id);
                SpongeMapStorage mapStorage = (SpongeMapStorage)Sponge.server().mapStorage();
                mapStorage.addMapInfo((MapInfo)((Object)this));
                this.impl$uuid = mapStorage.requestUUID(this.impl$mapId);
                return;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        SpongeCommon.logger().error("Map id could not be got from map name, (" + mapname + ")");
    }

    @Override
    public CompoundTag data$getCompound() {
        return this.impl$nbt;
    }

    @Override
    public void data$setCompound(CompoundTag nbt) {
        this.impl$nbt = nbt;
    }

    public void impl$addDecorationToDecorationsMapIfNotExists(MapDecoration mapDecoration) {
        MapDecorationBridge bridge = (MapDecorationBridge)mapDecoration;
        bridge.bridge$setPersistent(true);
        if (this.decorations.containsKey(bridge.bridge$getKey())) {
            return;
        }
        ((MapDecorationBridge)mapDecoration).notifyAddedToMap((MapInfo)((Object)this));
        this.decorations.put(bridge.bridge$getKey(), mapDecoration);
        this.setDirty();
    }

    @Nullable
    @Redirect(method={"addDecoration"}, at=@At(value="INVOKE", remap=false, target="Ljava/util/Map;put(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;"), allow=1)
    public Object impl$setKeyOnValue(Map map, Object key, Object value) {
        ((MapDecorationBridge)value).bridge$setKey((String)key);
        return map.put(key, value);
    }
}

