/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.minecraft.world.level.storage;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.storage.LevelData;
import org.spongepowered.api.util.MinecraftDayTime;
import org.spongepowered.api.world.difficulty.Difficulty;
import org.spongepowered.api.world.gamerule.GameRule;
import org.spongepowered.api.world.storage.WorldProperties;
import org.spongepowered.asm.mixin.Implements;
import org.spongepowered.asm.mixin.Interface;
import org.spongepowered.asm.mixin.Intrinsic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.accessor.world.level.GameRulesAccessor;
import org.spongepowered.common.accessor.world.level.GameRules_ValueAccessor;
import org.spongepowered.common.util.SpongeMinecraftDayTime;
import org.spongepowered.math.vector.Vector3i;

@Mixin(value={LevelData.class})
@Implements(value={@Interface(iface=WorldProperties.class, prefix="worldProperties$", remap=Interface.Remap.NONE)})
public interface LevelDataMixin_API
extends WorldProperties {
    @Shadow
    public int shadow$getXSpawn();

    @Shadow
    public int shadow$getYSpawn();

    @Shadow
    public int shadow$getZSpawn();

    @Shadow
    public long shadow$getGameTime();

    @Shadow
    public long shadow$getDayTime();

    @Shadow
    public boolean shadow$isHardcore();

    @Shadow
    public GameRules shadow$getGameRules();

    @Shadow
    public net.minecraft.world.Difficulty shadow$getDifficulty();

    @Override
    default public Vector3i spawnPosition() {
        return new Vector3i(this.shadow$getXSpawn(), this.shadow$getYSpawn(), this.shadow$getZSpawn());
    }

    @Intrinsic
    default public MinecraftDayTime worldProperties$gameTime() {
        return new SpongeMinecraftDayTime(this.shadow$getGameTime());
    }

    @Intrinsic
    default public MinecraftDayTime worldProperties$dayTime() {
        return new SpongeMinecraftDayTime(this.shadow$getDayTime());
    }

    @Intrinsic
    default public boolean worldProperties$hardcore() {
        return this.shadow$isHardcore();
    }

    @Intrinsic
    default public Difficulty worldProperties$difficulty() {
        return (Difficulty)this.shadow$getDifficulty();
    }

    @Override
    default public <V> V gameRule(GameRule<V> gameRule) {
        GameRules.Value value = this.shadow$getGameRules().getRule((GameRules.Key)Objects.requireNonNull(gameRule, "gameRule"));
        if (value instanceof GameRules.BooleanValue) {
            return (V)Boolean.valueOf(((GameRules.BooleanValue)value).get());
        }
        if (value instanceof GameRules.IntegerValue) {
            return (V)Integer.valueOf(((GameRules.IntegerValue)value).get());
        }
        return null;
    }

    @Override
    default public <V> void setGameRule(GameRule<V> gameRule, V value) {
        Objects.requireNonNull(gameRule, "gameRule");
        Objects.requireNonNull(value, "value");
        GameRules.Value mValue = this.shadow$getGameRules().getRule((GameRules.Key)gameRule);
        ((GameRules_ValueAccessor)mValue).invoker$deserialize(value.toString());
    }

    @Override
    default public Map<GameRule<?>, ?> gameRules() {
        Map<GameRules.Key<?>, GameRules.Value<?>> rules = ((GameRulesAccessor)this.shadow$getGameRules()).accessor$rules();
        HashMap<GameRule, Boolean> apiRules = new HashMap<GameRule, Boolean>();
        for (Map.Entry<GameRules.Key<?>, GameRules.Value<?>> rule : rules.entrySet()) {
            GameRule key = (GameRule)rule.getKey();
            GameRules.Value<?> mValue = rule.getValue();
            Comparable<Boolean> value = null;
            if (mValue instanceof GameRules.BooleanValue) {
                value = ((GameRules.BooleanValue)mValue).get();
            } else if (mValue instanceof GameRules.IntegerValue) {
                value = ((GameRules.IntegerValue)mValue).get();
            }
            if (value == null) continue;
            apiRules.put(key, (Boolean)value);
        }
        return apiRules;
    }
}

