/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.server;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetDisplayObjectivePacket;
import net.minecraft.network.protocol.game.ClientboundSetObjectivePacket;
import net.minecraft.network.protocol.game.ClientboundSetPlayerTeamPacket;
import net.minecraft.network.protocol.game.ClientboundSetScorePacket;
import net.minecraft.server.ServerScoreboard;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Score;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.criteria.ObjectiveCriteria;
import org.spongepowered.api.scoreboard.Team;
import org.spongepowered.api.scoreboard.criteria.Criterion;
import org.spongepowered.api.scoreboard.displayslot.DisplaySlot;
import org.spongepowered.api.scoreboard.objective.displaymode.ObjectiveDisplayMode;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.accessor.world.scores.PlayerTeamAccessor;
import org.spongepowered.common.accessor.world.scores.ScoreboardAccessor;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.bridge.server.ServerScoreboardBridge;
import org.spongepowered.common.bridge.world.scores.ObjectiveBridge;
import org.spongepowered.common.bridge.world.scores.ScoreBridge;
import org.spongepowered.common.scoreboard.SpongeDisplaySlot;
import org.spongepowered.common.scoreboard.SpongeObjective;
import org.spongepowered.common.scoreboard.SpongeScore;

@Mixin(value={ServerScoreboard.class})
public abstract class ServerScoreboardMixin
extends Scoreboard
implements ServerScoreboardBridge {
    private final List<ServerPlayer> impl$players = new ArrayList<ServerPlayer>();

    @Shadow
    protected abstract void shadow$setDirty();

    @Override
    public void bridge$updateDisplaySlot(@Nullable org.spongepowered.api.scoreboard.objective.Objective objective, DisplaySlot displaySlot) throws IllegalStateException {
        this.bridge$updateDisplaySlot(objective, ((SpongeDisplaySlot)displaySlot).index());
    }

    @Override
    public void bridge$updateDisplaySlot(@Nullable org.spongepowered.api.scoreboard.objective.Objective objective, int slot) throws IllegalStateException {
        if (objective != null && !objective.scoreboards().contains(this)) {
            throw new IllegalStateException("Attempting to set an objective's display slot that does not exist on this scoreboard!");
        }
        ((ScoreboardAccessor)((Object)this)).accessor$displayObjectives()[slot] = objective == null ? null : ((SpongeObjective)objective).getObjectiveFor(this);
        this.bridge$sendToPlayers((Packet<?>)new ClientboundSetDisplayObjectivePacket(slot, ((ScoreboardAccessor)((Object)this)).accessor$displayObjectives()[slot]));
    }

    @Override
    public void bridge$addObjective(org.spongepowered.api.scoreboard.objective.Objective objective) {
        Objective nmsObjective = this.getObjective(objective.name());
        if (nmsObjective != null) {
            throw new IllegalArgumentException(String.format("An objective with the name '%s' already exists!", objective.name()));
        }
        Objective scoreObjective = ((SpongeObjective)objective).getObjectiveFor(this);
        List<Objective> objectives = ((ScoreboardAccessor)((Object)this)).accessor$objectivesByCriteria().get(objective.criterion());
        if (objectives == null) {
            objectives = new ArrayList<Objective>();
            ((ScoreboardAccessor)((Object)this)).accessor$objectivesByCriteria().put((ObjectiveCriteria)objective.criterion(), objectives);
        }
        objectives.add(scoreObjective);
        ((ScoreboardAccessor)((Object)this)).accessor$objectivesByName().put(objective.name(), scoreObjective);
        this.onObjectiveAdded(scoreObjective);
        ((SpongeObjective)objective).updateScores(this);
    }

    @Override
    public Optional<org.spongepowered.api.scoreboard.objective.Objective> bridge$getObjective(String name) {
        Objective objective = this.getObjective(name);
        return Optional.ofNullable(objective == null ? null : ((ObjectiveBridge)objective).bridge$getSpongeObjective());
    }

    @Override
    public Optional<org.spongepowered.api.scoreboard.objective.Objective> bridge$getObjective(DisplaySlot slot) {
        Objective objective = ((ScoreboardAccessor)((Object)this)).accessor$displayObjectives()[((SpongeDisplaySlot)slot).index()];
        if (objective != null) {
            return Optional.of(((ObjectiveBridge)objective).bridge$getSpongeObjective());
        }
        return Optional.empty();
    }

    @Override
    public Set<org.spongepowered.api.scoreboard.objective.Objective> bridge$getObjectivesByCriterion(Criterion criterion) {
        if (((ScoreboardAccessor)((Object)this)).accessor$objectivesByCriteria().containsKey(criterion)) {
            return ((ScoreboardAccessor)((Object)this)).accessor$objectivesByCriteria().get(criterion).stream().map(objective -> ((ObjectiveBridge)objective).bridge$getSpongeObjective()).collect(Collectors.toSet());
        }
        return new HashSet<org.spongepowered.api.scoreboard.objective.Objective>();
    }

    @Override
    public void bridge$removeObjective(org.spongepowered.api.scoreboard.objective.Objective objective) {
        Objective scoreObjective = ((SpongeObjective)objective).getObjectiveFor(this);
        ((ScoreboardAccessor)((Object)this)).accessor$objectivesByName().remove(scoreObjective.getName());
        for (int i = 0; i < 19; ++i) {
            if (this.getDisplayObjective(i) != scoreObjective) continue;
            this.setDisplayObjective(i, null);
        }
        this.bridge$sendToPlayers((Packet<?>)new ClientboundSetObjectivePacket(scoreObjective, 1));
        List<Objective> list = ((ScoreboardAccessor)((Object)this)).accessor$objectivesByCriteria().get(scoreObjective.getCriteria());
        if (list != null) {
            list.remove(scoreObjective);
        }
        for (Map<Objective, Score> scoreMap : ((ScoreboardAccessor)((Object)this)).accessor$playerScores().values()) {
            Score score = scoreMap.remove(scoreObjective);
            if (score == null) continue;
            ((ScoreBridge)score).bridge$getSpongeScore().removeScoreFor(scoreObjective);
        }
        this.shadow$setDirty();
        ((SpongeObjective)objective).removeObjectiveFor(this);
    }

    @Override
    public void bridge$registerTeam(Team spongeTeam) {
        PlayerTeam team = (PlayerTeam)spongeTeam;
        if (this.getPlayerTeam(spongeTeam.name()) != null) {
            throw new IllegalArgumentException(String.format("A team with the name '%s' already exists!", spongeTeam.name()));
        }
        if (((PlayerTeamAccessor)team).accessor$scoreboard() != null) {
            throw new IllegalArgumentException("The passed in team is already registered to a scoreboard!");
        }
        ((PlayerTeamAccessor)team).accessor$scoreboard(this);
        ((ScoreboardAccessor)((Object)this)).accessor$teamsByName().put(team.getName(), team);
        for (String entry : team.getPlayers()) {
            this.addPlayerToTeam(entry, team);
        }
        this.onTeamAdded(team);
    }

    @Override
    public void bridge$sendToPlayers(Packet<?> packet) {
        for (ServerPlayer player : this.impl$players) {
            player.connection.send(packet);
        }
    }

    @Override
    public void bridge$addPlayer(ServerPlayer player, boolean sendPackets) {
        this.impl$players.add(player);
        if (sendPackets) {
            for (PlayerTeam team : this.getPlayerTeams()) {
                player.connection.send((Packet)new ClientboundSetPlayerTeamPacket(team, 0));
            }
            for (Objective objective : this.getObjectives()) {
                player.connection.send((Packet)new ClientboundSetObjectivePacket(objective, 0));
                for (int i = 0; i < 19; ++i) {
                    if (this.getDisplayObjective(i) != objective) continue;
                    player.connection.send((Packet)new ClientboundSetDisplayObjectivePacket(i, objective));
                }
                for (Score score : this.getPlayerScores(objective)) {
                    ClientboundSetScorePacket packetIn = new ClientboundSetScorePacket(ServerScoreboard.Method.CHANGE, score.getObjective().getName(), score.getOwner(), score.getScore());
                    player.connection.send((Packet)packetIn);
                }
            }
        }
    }

    @Override
    public void bridge$removePlayer(ServerPlayer player, boolean sendPackets) {
        this.impl$players.remove(player);
        if (sendPackets) {
            this.impl$removeScoreboard(player);
        }
    }

    public Objective addObjective(String name, ObjectiveCriteria criteria, net.minecraft.network.chat.Component text, ObjectiveCriteria.RenderType type) {
        SpongeObjective objective = new SpongeObjective(name, (Criterion)criteria);
        objective.setDisplayMode((ObjectiveDisplayMode)type);
        objective.setDisplayName(SpongeAdventure.asAdventure(text));
        ((org.spongepowered.api.scoreboard.Scoreboard)((Object)this)).addObjective(objective);
        return objective.getObjectiveFor(this);
    }

    public void removeObjective(Objective objective) {
        this.bridge$removeObjective(((ObjectiveBridge)objective).bridge$getSpongeObjective());
    }

    public void removePlayerTeam(PlayerTeam team) {
        super.removePlayerTeam(team);
        ((PlayerTeamAccessor)team).accessor$scoreboard(null);
    }

    public Score getOrCreatePlayerScore(String name, Objective objective) {
        return ((SpongeScore)((ObjectiveBridge)objective).bridge$getSpongeObjective().findOrCreateScore((Component)LegacyComponentSerializer.legacySection().deserialize(name))).getScoreFor(objective);
    }

    public void resetPlayerScore(String name, Objective objective) {
        LegacyComponentSerializer lcs = LegacyComponentSerializer.legacySection();
        if (objective != null) {
            SpongeObjective spongeObjective = ((ObjectiveBridge)objective).bridge$getSpongeObjective();
            Optional<org.spongepowered.api.scoreboard.Score> score = spongeObjective.findScore((Component)lcs.deserialize(name));
            if (score.isPresent()) {
                spongeObjective.removeScore(score.get());
            } else {
                SpongeCommon.logger().warn("Objective {} did have have the score", (Object)name);
            }
        } else {
            TextComponent textName = lcs.deserialize(name);
            for (Objective scoreObjective : this.getObjectives()) {
                ((ObjectiveBridge)scoreObjective).bridge$getSpongeObjective().removeScore((Component)textName);
            }
        }
    }

    @Redirect(method={"onScoreChanged"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/players/PlayerList;broadcastAll(Lnet/minecraft/network/protocol/Packet;)V"))
    private void onUpdateScoreValue(PlayerList manager, Packet<?> packet) {
        this.bridge$sendToPlayers(packet);
    }

    @Redirect(method={"onScoreChanged"}, at=@At(value="INVOKE", target="Ljava/util/Set;contains(Ljava/lang/Object;)Z", remap=false))
    private boolean onUpdateScoreValue(Set<?> set, Object object) {
        return true;
    }

    @Redirect(method={"onPlayerRemoved"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/players/PlayerList;broadcastAll(Lnet/minecraft/network/protocol/Packet;)V"))
    private void impl$updatePlayersOnRemoval(PlayerList manager, Packet<?> packet) {
        this.bridge$sendToPlayers(packet);
    }

    @Redirect(method={"onPlayerScoreRemoved"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/players/PlayerList;broadcastAll(Lnet/minecraft/network/protocol/Packet;)V"))
    private void impl$updatePlayersOnRemovalOfObjective(PlayerList manager, Packet<?> packet) {
        this.bridge$sendToPlayers(packet);
    }

    @Inject(method={"onObjectiveAdded"}, at={@At(value="RETURN")})
    private void impl$UpdatePlayersScoreObjective(Objective objective, CallbackInfo ci) {
        this.bridge$sendToPlayers((Packet<?>)new ClientboundSetObjectivePacket(objective, 0));
    }

    @Overwrite
    public void setDisplayObjective(int slot, @Nullable Objective objective) {
        SpongeObjective apiObjective = objective == null ? null : ((ObjectiveBridge)objective).bridge$getSpongeObjective();
        this.bridge$updateDisplaySlot((org.spongepowered.api.scoreboard.objective.Objective)apiObjective, slot);
    }

    @Redirect(method={"addPlayerToTeam"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/players/PlayerList;broadcastAll(Lnet/minecraft/network/protocol/Packet;)V"))
    private void impl$updatePlayersOnPlayerAdd(PlayerList manager, Packet<?> packet) {
        this.bridge$sendToPlayers(packet);
    }

    @Redirect(method={"removePlayerFromTeam(Ljava/lang/String;Lnet/minecraft/world/scores/PlayerTeam;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/players/PlayerList;broadcastAll(Lnet/minecraft/network/protocol/Packet;)V"))
    private void impl$updatePlayersOnPlayerRemoval(PlayerList manager, Packet<?> packet) {
        this.bridge$sendToPlayers(packet);
    }

    @Redirect(method={"onObjectiveChanged"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/players/PlayerList;broadcastAll(Lnet/minecraft/network/protocol/Packet;)V"))
    private void impl$updatePlayersOnObjectiveDisplay(PlayerList manager, Packet<?> packet) {
        this.bridge$sendToPlayers(packet);
    }

    @Redirect(method={"onObjectiveChanged"}, at=@At(value="INVOKE", target="Ljava/util/Set;contains(Ljava/lang/Object;)Z", remap=false))
    private boolean impl$alwaysReturnTrueForObjectivesDisplayName(Set<Objective> set, Object object) {
        return true;
    }

    @Redirect(method={"onObjectiveRemoved"}, at=@At(value="INVOKE", target="Ljava/util/Set;contains(Ljava/lang/Object;)Z", remap=false))
    private boolean impl$alwaysReturnTrueForObjectiveRemoval(Set<Objective> set, Object object) {
        return true;
    }

    @Redirect(method={"onTeamAdded"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/players/PlayerList;broadcastAll(Lnet/minecraft/network/protocol/Packet;)V"))
    private void impl$updateAllPlayersOnTeamCreation(PlayerList manager, Packet<?> packet) {
        this.bridge$sendToPlayers(packet);
    }

    @Redirect(method={"onTeamChanged"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/players/PlayerList;broadcastAll(Lnet/minecraft/network/protocol/Packet;)V"))
    private void impl$updateAllPlayersOnTeamInfo(PlayerList manager, Packet<?> packet) {
        this.bridge$sendToPlayers(packet);
    }

    @Redirect(method={"onTeamRemoved"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/players/PlayerList;broadcastAll(Lnet/minecraft/network/protocol/Packet;)V"))
    private void impl$updateAllPlayersOnTeamRemoval(PlayerList manager, Packet<?> packet) {
        this.bridge$sendToPlayers(packet);
    }

    @Redirect(method={"startTrackingObjective"}, at=@At(value="INVOKE", target="Ljava/util/List;iterator()Ljava/util/Iterator;", ordinal=0, remap=false))
    private Iterator impl$useOurScoreboardForPlayers(List list) {
        return this.impl$players.iterator();
    }

    @Redirect(method={"stopTrackingObjective"}, at=@At(value="INVOKE", target="Ljava/util/List;iterator()Ljava/util/Iterator;", ordinal=0, remap=false))
    private Iterator impl$useOurScoreboardForPlayersOnRemoval(List list) {
        return this.impl$players.iterator();
    }

    private void impl$removeScoreboard(ServerPlayer player) {
        this.impl$removeTeams(player);
        this.impl$removeObjectives(player);
    }

    private void impl$removeTeams(ServerPlayer player) {
        for (PlayerTeam team : this.getPlayerTeams()) {
            player.connection.send((Packet)new ClientboundSetPlayerTeamPacket(team, 1));
        }
    }

    private void impl$removeObjectives(ServerPlayer player) {
        for (Objective objective : this.getObjectives()) {
            player.connection.send((Packet)new ClientboundSetObjectivePacket(objective, 1));
        }
    }
}

