/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.server.network;

import com.google.common.collect.ImmutableList;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.identity.Identified;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.minecraft.SharedConstants;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.Connection;
import net.minecraft.network.PacketListener;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketUtils;
import net.minecraft.network.protocol.game.ClientboundBlockBreakAckPacket;
import net.minecraft.network.protocol.game.ClientboundCommandSuggestionsPacket;
import net.minecraft.network.protocol.game.ClientboundMoveVehiclePacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerPositionPacket;
import net.minecraft.network.protocol.game.ClientboundResourcePackPacket;
import net.minecraft.network.protocol.game.ServerGamePacketListener;
import net.minecraft.network.protocol.game.ServerboundCommandSuggestionPacket;
import net.minecraft.network.protocol.game.ServerboundInteractPacket;
import net.minecraft.network.protocol.game.ServerboundMovePlayerPacket;
import net.minecraft.network.protocol.game.ServerboundMoveVehiclePacket;
import net.minecraft.network.protocol.game.ServerboundPlayerActionPacket;
import net.minecraft.network.protocol.game.ServerboundResourcePackPacket;
import net.minecraft.network.protocol.game.ServerboundSignUpdatePacket;
import net.minecraft.network.protocol.game.ServerboundSwingPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayerGameMode;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.block.entity.Sign;
import org.spongepowered.api.command.CommandCause;
import org.spongepowered.api.command.manager.CommandMapping;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.data.type.HandType;
import org.spongepowered.api.data.value.ListValue;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.Humanoid;
import org.spongepowered.api.entity.living.player.PlayerChatFormatter;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.event.Cancellable;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.block.InteractBlockEvent;
import org.spongepowered.api.event.block.entity.ChangeSignEvent;
import org.spongepowered.api.event.cause.entity.MovementTypes;
import org.spongepowered.api.event.entity.InteractEntityEvent;
import org.spongepowered.api.event.entity.living.AnimateHandEvent;
import org.spongepowered.api.event.message.PlayerChatEvent;
import org.spongepowered.api.event.network.ServerSideConnectionEvent;
import org.spongepowered.api.resourcepack.ResourcePack;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.accessor.network.protocol.game.ServerboundMovePlayerPacketAccessor;
import org.spongepowered.common.accessor.network.protocol.game.ServerboundMoveVehiclePacketAccessor;
import org.spongepowered.common.accessor.server.level.ServerPlayerGameModeAccessor;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.bridge.network.ConnectionHolderBridge;
import org.spongepowered.common.bridge.network.protocol.game.ClientboundResourcePackPacketBridge;
import org.spongepowered.common.bridge.server.level.ServerPlayerBridge;
import org.spongepowered.common.bridge.server.network.ServerGamePacketListenerImplBridge;
import org.spongepowered.common.command.manager.SpongeCommandManager;
import org.spongepowered.common.command.registrar.BrigadierBasedRegistrar;
import org.spongepowered.common.data.value.ImmutableSpongeListValue;
import org.spongepowered.common.entity.player.tab.SpongeTabList;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.phase.packet.BasicPacketContext;
import org.spongepowered.common.event.tracking.phase.packet.PacketPhase;
import org.spongepowered.common.hooks.PlatformHooks;
import org.spongepowered.common.item.util.ItemStackUtil;
import org.spongepowered.common.util.CommandUtil;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.math.vector.Vector3d;

@Mixin(value={ServerGamePacketListenerImpl.class})
public abstract class ServerGamePacketListenerImplMixin
implements ServerGamePacketListenerImplBridge,
ConnectionHolderBridge {
    @Shadow
    @Final
    public Connection connection;
    @Shadow
    public net.minecraft.server.level.ServerPlayer player;
    @Shadow
    @Final
    private MinecraftServer server;
    @Shadow
    private double vehicleFirstGoodX;
    @Shadow
    private double vehicleFirstGoodY;
    @Shadow
    private double vehicleFirstGoodZ;
    @Shadow
    private double vehicleLastGoodX;
    @Shadow
    private double vehicleLastGoodY;
    @Shadow
    private double vehicleLastGoodZ;
    @Shadow
    private int chatSpamTickCount;
    private int impl$ignorePackets;
    private @Nullable ResourcePack impl$lastReceivedPack;
    private @Nullable ResourcePack impl$lastAcceptedPack;

    @Shadow
    public abstract void shadow$teleport(double var1, double var3, double var5, float var7, float var8, Set<ClientboundPlayerPositionPacket.RelativeArgument> var9);

    @Shadow
    protected abstract void shadow$filterTextPacket(List<String> var1, Consumer<List<String>> var2);

    @Override
    public Connection bridge$getConnection() {
        return this.connection;
    }

    @Inject(method={"send(Lnet/minecraft/network/protocol/Packet;Lio/netty/util/concurrent/GenericFutureListener;)V"}, at={@At(value="HEAD")})
    private void impl$onClientboundPacketSend(Packet<?> packet, GenericFutureListener<? extends Future<? super Void>> listener, CallbackInfo ci) {
        if (packet instanceof ClientboundPlayerInfoPacket) {
            ((SpongeTabList)((ServerPlayer)this.player).tabList()).updateEntriesOnSend((ClientboundPlayerInfoPacket)packet);
        } else if (packet instanceof ClientboundResourcePackPacket) {
            ResourcePack pack;
            this.impl$lastReceivedPack = pack = ((ClientboundResourcePackPacketBridge)packet).bridge$getSpongePack();
        }
    }

    @Inject(method={"handleCustomCommandSuggestions"}, at={@At(value="NEW", target="com/mojang/brigadier/StringReader", remap=false)}, cancellable=true)
    private void impl$getSuggestionsFromNonBrigCommand(ServerboundCommandSuggestionPacket packet, CallbackInfo ci) {
        String rawCommand = packet.getCommand();
        String[] command = CommandUtil.extractCommandString(rawCommand);
        CommandCause cause = CommandCause.create();
        SpongeCommandManager manager = SpongeCommandManager.get(this.server);
        if (!rawCommand.contains(" ")) {
            SuggestionsBuilder builder = new SuggestionsBuilder(command[0], 0);
            if (command[0].isEmpty()) {
                manager.getAliasesForCause(cause).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
            } else {
                manager.getAliasesThatStartWithForCause(cause, command[0]).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
            }
            this.connection.send((Packet)new ClientboundCommandSuggestionsPacket(packet.getId(), builder.build()));
            ci.cancel();
        } else {
            Optional<CommandMapping> mappingOptional = manager.commandMapping(command[0].toLowerCase(Locale.ROOT)).filter(x -> !(x.registrar() instanceof BrigadierBasedRegistrar));
            if (mappingOptional.isPresent()) {
                CommandMapping mapping = mappingOptional.get();
                if (mapping.registrar().canExecute(cause, mapping)) {
                    SuggestionsBuilder builder = CommandUtil.createSuggestionsForRawCommand(rawCommand, command, cause, mapping);
                    this.connection.send((Packet)new ClientboundCommandSuggestionsPacket(packet.getId(), builder.build()));
                } else {
                    this.connection.send((Packet)new ClientboundCommandSuggestionsPacket(packet.getId(), (Suggestions)Suggestions.empty().join()));
                }
                ci.cancel();
            }
        }
    }

    @Redirect(method={"handleCustomCommandSuggestions"}, at=@At(value="INVOKE", target="Lcom/mojang/brigadier/CommandDispatcher;parse(Lcom/mojang/brigadier/StringReader;Ljava/lang/Object;)Lcom/mojang/brigadier/ParseResults;", remap=false))
    private ParseResults<CommandSourceStack> impl$informParserThisIsASuggestionCheck(CommandDispatcher<CommandSourceStack> commandDispatcher, StringReader command, Object source) {
        return SpongeCommandManager.get(this.server).getDispatcher().parse(command, (CommandSourceStack)source, true);
    }

    @ModifyConstant(method={"handleInteract"}, constant={@Constant(doubleValue=36.0)})
    private double impl$getPlatformReach(double thirtySix, ServerboundInteractPacket p_147340_1_) {
        return PlatformHooks.INSTANCE.getGeneralHooks().getEntityReachDistanceSq(this.player, p_147340_1_.getTarget(this.player.level));
    }

    @Inject(method={"handleMovePlayer"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerPlayer;isPassenger()Z")}, cancellable=true)
    private void impl$callMoveEntityEvent(ServerboundMovePlayerPacket packetIn, CallbackInfo ci) {
        Vector3d toRotation;
        Vector3d toPosition;
        ServerboundMovePlayerPacketAccessor packetInAccessor = (ServerboundMovePlayerPacketAccessor)packetIn;
        boolean fireMoveEvent = packetInAccessor.accessor$hasPos();
        boolean fireRotationEvent = packetInAccessor.accessor$hasRot();
        if (!fireMoveEvent && !fireRotationEvent) {
            return;
        }
        ServerPlayer player = (ServerPlayer)this.player;
        Vector3d fromPosition = player.position();
        Vector3d fromRotation = player.rotation();
        Vector3d originalToPosition = new Vector3d(packetIn.getX(this.player.getX()), packetIn.getY(this.player.getY()), packetIn.getZ(this.player.getZ()));
        Vector3d originalToRotation = new Vector3d(packetIn.getYRot(this.player.yRot), packetIn.getXRot(this.player.xRot), 0.0f);
        if (fireMoveEvent) {
            try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
                frame.addContext(EventContextKeys.MOVEMENT_TYPE, MovementTypes.NATURAL);
                toPosition = SpongeCommonEventFactory.callMoveEvent(player, fromPosition, originalToPosition);
            }
        } else {
            toPosition = originalToPosition;
        }
        if (fireRotationEvent) {
            toRotation = SpongeCommonEventFactory.callRotateEvent(player, fromRotation, originalToRotation);
            if (toRotation == null) {
                toRotation = fromRotation;
            }
        } else {
            toRotation = originalToRotation;
        }
        if (toPosition == null) {
            this.player.absMoveTo(fromPosition.x(), fromPosition.y(), fromPosition.z(), (float)originalToRotation.x(), (float)originalToRotation.y());
            this.shadow$teleport(fromPosition.x(), fromPosition.y(), fromPosition.z(), (float)toRotation.x(), (float)toRotation.y(), EnumSet.of(ClientboundPlayerPositionPacket.RelativeArgument.X_ROT, ClientboundPlayerPositionPacket.RelativeArgument.Y_ROT));
            ci.cancel();
            return;
        }
        if (!toPosition.equals((Object)originalToPosition) || !toRotation.equals((Object)originalToRotation)) {
            this.player.absMoveTo(originalToPosition.x(), originalToPosition.y(), originalToPosition.z(), (float)originalToRotation.x(), (float)originalToRotation.y());
            this.shadow$teleport(toPosition.x(), toPosition.y(), toPosition.z(), (float)toRotation.x(), (float)toRotation.y(), EnumSet.allOf(ClientboundPlayerPositionPacket.RelativeArgument.class));
            ci.cancel();
        }
    }

    @Inject(method={"handleMoveVehicle"}, cancellable=true, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;getControllingPassenger()Lnet/minecraft/world/entity/Entity;")})
    private void impl$handleVehicleMoveEvent(ServerboundMoveVehiclePacket param0, CallbackInfo ci) {
        ServerboundMoveVehiclePacketAccessor packet = (ServerboundMoveVehiclePacketAccessor)param0;
        net.minecraft.world.entity.Entity rootVehicle = this.player.getRootVehicle();
        Vector3d fromRotation = new Vector3d(rootVehicle.yRot, rootVehicle.xRot, 0.0f);
        Vector3d fromPosition = VecHelper.toVector3d(rootVehicle.position());
        Vector3d originalToPosition = new Vector3d(param0.getX(), param0.getY(), param0.getZ());
        Vector3d originalToRotation = new Vector3d(param0.getYRot(), param0.getXRot(), 0.0f);
        @Nullable Vector3d toPosition = SpongeCommonEventFactory.callMoveEvent((Entity)rootVehicle, fromPosition, originalToPosition);
        Vector3d toRotation = SpongeCommonEventFactory.callRotateEvent((Entity)rootVehicle, fromRotation, originalToRotation);
        if (toRotation == null) {
            toRotation = fromRotation;
        }
        if (toPosition == null) {
            if (!fromRotation.equals((Object)toRotation)) {
                rootVehicle.absMoveTo(rootVehicle.getX(), rootVehicle.getY(), rootVehicle.getZ(), (float)toRotation.y(), (float)toRotation.x());
            }
            this.connection.send((Packet)new ClientboundMoveVehiclePacket(rootVehicle));
            ci.cancel();
            return;
        }
        if (!toPosition.equals((Object)originalToPosition) || !toRotation.equals((Object)originalToRotation)) {
            rootVehicle.absMoveTo(toPosition.x(), toPosition.y(), toPosition.z(), (float)toRotation.y(), (float)toRotation.x());
            this.connection.send((Packet)new ClientboundMoveVehiclePacket(rootVehicle));
            packet.accessor$x(toPosition.x());
            packet.accessor$y(toPosition.y());
            packet.accessor$z(toPosition.z());
            packet.accessor$yRot((float)toRotation.x());
            packet.accessor$xRot((float)toRotation.y());
            this.vehicleFirstGoodX = toPosition.x();
            this.vehicleFirstGoodY = toPosition.y();
            this.vehicleFirstGoodZ = toPosition.z();
        }
    }

    @Inject(method={"handleInteract"}, cancellable=true, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;interactAt(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/InteractionResult;")})
    public void impl$onRightClickAtEntity(ServerboundInteractPacket packet, CallbackInfo ci) {
        net.minecraft.world.entity.Entity entity = packet.getTarget((Level)this.player.getLevel());
        ItemStack itemInHand = packet.getHand() == null ? ItemStack.EMPTY : this.player.getItemInHand(packet.getHand());
        InteractEntityEvent.Secondary event = SpongeCommonEventFactory.callInteractEntityEventSecondary(this.player, itemInHand, entity, packet.getHand(), VecHelper.toVector3d(packet.getLocation()));
        if (event.isCancelled()) {
            ci.cancel();
        } else {
            ++this.impl$ignorePackets;
        }
    }

    @Inject(method={"handleInteract"}, cancellable=true, at={@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerPlayer;attack(Lnet/minecraft/world/entity/Entity;)V")})
    public void impl$onLeftClickEntity(ServerboundInteractPacket packet, CallbackInfo ci) {
        net.minecraft.world.entity.Entity entity = packet.getTarget((Level)this.player.getLevel());
        InteractEntityEvent.Primary event = SpongeCommonEventFactory.callInteractEntityEventPrimary(this.player, this.player.getItemInHand(this.player.getUsedItemHand()), entity, this.player.getUsedItemHand());
        if (event.isCancelled()) {
            ci.cancel();
        } else {
            ++this.impl$ignorePackets;
        }
    }

    @Inject(method={"handleAnimate"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerPlayer;resetLastActionTime()V")}, cancellable=true)
    private void impl$throwAnimationAndInteractEvents(ServerboundSwingPacket packetIn, CallbackInfo ci) {
        if (PhaseTracker.getInstance().getPhaseContext().isEmpty()) {
            return;
        }
        InteractionHand hand = packetIn.getHand();
        if (!((ServerPlayerGameModeAccessor)this.player.gameMode).accessor$isDestroyingBlock()) {
            if (this.impl$ignorePackets > 0) {
                --this.impl$ignorePackets;
            } else if (ShouldFire.INTERACT_ITEM_EVENT_PRIMARY) {
                double reachDistance = ((ServerPlayerBridge)this.player).bridge$reachDistance();
                double pickRange = this.player.gameMode.isCreative() ? reachDistance : reachDistance - 0.5;
                Vec3 startPos = this.player.getEyePosition(1.0f);
                Vec3 endPos = startPos.add(this.player.getLookAngle().scale(pickRange));
                BlockHitResult result = this.player.getLevel().clip(new ClipContext(startPos, endPos, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (net.minecraft.world.entity.Entity)this.player));
                if (result.getType() == HitResult.Type.MISS) {
                    ItemStack heldItem = this.player.getItemInHand(hand);
                    SpongeCommonEventFactory.callInteractItemEventPrimary((Player)this.player, heldItem, hand);
                }
            }
        }
        if (ShouldFire.ANIMATE_HAND_EVENT) {
            HandType handType = (HandType)hand;
            ItemStack heldItem = this.player.getItemInHand(hand);
            try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
                frame.addContext(EventContextKeys.USED_ITEM, ItemStackUtil.snapshotOf(heldItem));
                frame.addContext(EventContextKeys.USED_HAND, handType);
                AnimateHandEvent event = SpongeEventFactory.createAnimateHandEvent(frame.currentCause(), handType, (Humanoid)this.player);
                if (SpongeCommon.post(event)) {
                    ci.cancel();
                }
            }
        }
    }

    @Inject(method={"handlePlayerAction"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerPlayer;drop(Z)Z")})
    public void impl$dropItem(ServerboundPlayerActionPacket p_147345_1_, CallbackInfo ci) {
        ++this.impl$ignorePackets;
    }

    @Redirect(method={"handlePlayerAction"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerPlayerGameMode;handleBlockBreakAction(Lnet/minecraft/core/BlockPos;Lnet/minecraft/network/protocol/game/ServerboundPlayerActionPacket$Action;Lnet/minecraft/core/Direction;I)V"))
    public void impl$callInteractBlockPrimaryEvent(ServerPlayerGameMode playerInteractionManager, BlockPos blockPos, ServerboundPlayerActionPacket.Action action, Direction direction, int maxBuildHeight) {
        BlockSnapshot snapshot = ((ServerWorld)playerInteractionManager.level).createSnapshot(VecHelper.toVector3i(blockPos));
        InteractBlockEvent.Primary event = SpongeCommonEventFactory.callInteractBlockEventPrimary(action, (Player)this.player, this.player.getItemInHand(InteractionHand.MAIN_HAND), snapshot, InteractionHand.MAIN_HAND, direction);
        if (event instanceof Cancellable && ((Cancellable)((Object)event)).isCancelled()) {
            this.player.connection.send((Packet)new ClientboundBlockBreakAckPacket(blockPos, playerInteractionManager.level.getBlockState(blockPos), action, false, "block action restricted"));
            ++this.impl$ignorePackets;
        } else {
            if (action == ServerboundPlayerActionPacket.Action.ABORT_DESTROY_BLOCK && !Objects.equals(((ServerPlayerGameModeAccessor)playerInteractionManager).accessor$destroyPos(), blockPos)) {
                return;
            }
            playerInteractionManager.handleBlockBreakAction(blockPos, action, direction, maxBuildHeight);
            if (action == ServerboundPlayerActionPacket.Action.START_DESTROY_BLOCK) {
                ++this.impl$ignorePackets;
            }
        }
    }

    @Redirect(method={"onDisconnect"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/players/PlayerList;broadcastMessage(Lnet/minecraft/network/chat/Component;Lnet/minecraft/network/chat/ChatType;Ljava/util/UUID;)V"))
    public void impl$handlePlayerDisconnect(PlayerList playerList, net.minecraft.network.chat.Component component, ChatType chatType, UUID uuid) {
        if (this.player.connection == null) {
            return;
        }
        ServerPlayer spongePlayer = (ServerPlayer)this.player;
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            frame.pushCause(this.player);
            Component message = SpongeAdventure.asAdventure(component);
            Audience audience = Sponge.server().broadcastAudience();
            ServerSideConnectionEvent.Disconnect event = SpongeEventFactory.createServerSideConnectionEventDisconnect(PhaseTracker.getCauseStackManager().currentCause(), audience, Optional.of(audience), message, message, spongePlayer.connection(), spongePlayer);
            SpongeCommon.post(event);
            event.audience().ifPresent(a -> a.sendMessage((Identified)spongePlayer, event.message()));
        }
        ((ServerPlayerBridge)this.player).bridge$getWorldBorderListener().onPlayerDisconnect();
    }

    @Redirect(method={"handleSignUpdate"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/network/ServerGamePacketListenerImpl;filterTextPacket(Ljava/util/List;Ljava/util/function/Consumer;)V"))
    private void impl$switchToSignPhaseState(ServerGamePacketListenerImpl serverPlayNetHandler, List<String> p_244537_1_, Consumer<List<String>> p_244537_2_) {
        try (BasicPacketContext context = (BasicPacketContext)((BasicPacketContext)PacketPhase.General.UPDATE_SIGN.createPhaseContext(PhaseTracker.getInstance()).packetPlayer(this.player)).buildAndSwitch();){
            this.shadow$filterTextPacket(p_244537_1_, p_244537_2_);
        }
    }

    @Redirect(method={"updateSignText"}, at=@At(value="INVOKE", remap=false, target="Ljava/util/List;size()I"))
    private int impl$callChangeSignEvent(List<String> list, ServerboundSignUpdatePacket p_244542_1_, List<String> p_244542_2_) {
        SignBlockEntity blockEntity = (SignBlockEntity)this.player.level.getBlockEntity(p_244542_1_.getPos());
        ListValue.Mutable<Component> originalLinesValue = ((Sign)blockEntity).getValue(Keys.SIGN_LINES).orElseGet(() -> new ImmutableSpongeListValue(Keys.SIGN_LINES, ImmutableList.of()));
        ArrayList<TextComponent> newLines = new ArrayList<TextComponent>();
        for (String line : list) {
            newLines.add(Component.text((String)SharedConstants.filterText((String)line)));
        }
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            frame.pushCause(this.player);
            ListValue.Mutable<Component> newLinesValue = ListValue.mutableOf(Keys.SIGN_LINES, newLines);
            ChangeSignEvent event = SpongeEventFactory.createChangeSignEvent(PhaseTracker.getCauseStackManager().currentCause(), (ListValue.Immutable<Component>)originalLinesValue.asImmutable(), newLinesValue, (Sign)blockEntity);
            ListValue.Mutable<Component> toApply = SpongeCommon.post(event) ? originalLinesValue : newLinesValue;
            ((Sign)blockEntity).offer(toApply);
        }
        return 0;
    }

    @Redirect(method={"handleChat(Ljava/lang/String;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/players/PlayerList;broadcastMessage(Lnet/minecraft/network/chat/Component;Lnet/minecraft/network/chat/ChatType;Ljava/util/UUID;)V"))
    private void impl$postChatMessageEventAndSend(PlayerList playerList, net.minecraft.network.chat.Component component, ChatType chatType, UUID playerUUID, String initialMessage) {
        ServerPlayer player = (ServerPlayer)this.player;
        PlayerChatFormatter chatFormatter = player.chatFormatter();
        TextComponent currentMessage = Component.text((String)initialMessage);
        if (component instanceof TranslatableComponent && ((TranslatableComponent)component).getArgs().length == 2) {
            if (((TranslatableComponent)component).getArgs()[1] instanceof net.minecraft.network.chat.Component) {
                currentMessage = SpongeAdventure.asAdventure((net.minecraft.network.chat.Component)((TranslatableComponent)component).getArgs()[1]);
            } else if (((TranslatableComponent)component).getArgs()[1] instanceof String) {
                currentMessage = Component.text((String)((String)((TranslatableComponent)component).getArgs()[1]));
            }
        }
        try (CauseStackManager.StackFrame frame = PhaseTracker.SERVER.pushCauseFrame();){
            frame.pushCause(this.player);
            Audience audience = (Audience)this.server;
            PlayerChatEvent event = SpongeEventFactory.createPlayerChatEvent(frame.currentCause(), audience, Optional.of(audience), chatFormatter, Optional.of(chatFormatter), (Component)currentMessage, (Component)currentMessage);
            if (SpongeCommon.post(event)) {
                this.chatSpamTickCount -= 20;
            } else {
                event.chatFormatter().ifPresent(formatter -> event.audience().map(SpongeAdventure::unpackAudiences).ifPresent(targets -> {
                    for (Audience target : targets) {
                        formatter.format(player, target, event.message(), event.originalMessage()).ifPresent(formattedMessage -> target.sendMessage((Identified)player, formattedMessage));
                    }
                }));
            }
        }
    }

    @Inject(method={"handleResourcePackResponse"}, at={@At(value="HEAD")})
    public void impl$handleResourcePackResponse(ServerboundResourcePackPacket packet, CallbackInfo callbackInfo) {
        PacketUtils.ensureRunningOnSameThread((Packet)packet, (PacketListener)((ServerGamePacketListener)this), (ServerLevel)this.player.getLevel());
    }

    @Override
    public @Nullable ResourcePack bridge$popReceivedResourcePack(boolean markAccepted) {
        ResourcePack pack = this.impl$lastReceivedPack;
        this.impl$lastReceivedPack = null;
        if (markAccepted) {
            this.impl$lastAcceptedPack = pack;
        }
        return pack;
    }

    @Override
    public @Nullable ResourcePack bridge$popAcceptedResourcePack() {
        ResourcePack pack = this.impl$lastAcceptedPack;
        this.impl$lastAcceptedPack = null;
        return pack;
    }
}

