/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.entity.item;

import net.minecraft.tags.BlockTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.common.bridge.world.damagesource.DamageSourceBridge;
import org.spongepowered.common.mixin.core.world.entity.EntityMixin;
import org.spongepowered.common.util.MinecraftFallingBlockDamageSource;

@Mixin(value={FallingBlockEntity.class})
public abstract class FallingBlockEntityMixin
extends EntityMixin {
    @Shadow
    private BlockState blockState;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Redirect(method={"causeFallDamage"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;hurt(Lnet/minecraft/world/damagesource/DamageSource;F)Z"))
    private boolean spongeAttackFallingOrAnvil(Entity entity, DamageSource source, float damage) {
        if (entity.level.isClientSide) {
            return entity.hurt(source, damage);
        }
        boolean isAnvil = this.blockState.getBlock().is((Tag)BlockTags.ANVIL);
        try {
            if (isAnvil) {
                MinecraftFallingBlockDamageSource anvil = new MinecraftFallingBlockDamageSource("anvil", (FallingBlockEntity)this);
                ((DamageSourceBridge)((Object)anvil)).bridge$setAnvilSource();
                boolean bl = entity.hurt(DamageSource.ANVIL, damage);
                return bl;
            }
            MinecraftFallingBlockDamageSource fallingblock = new MinecraftFallingBlockDamageSource("fallingblock", (FallingBlockEntity)this);
            ((DamageSourceBridge)((Object)fallingblock)).bridge$setFallingBlockSource();
            boolean bl = entity.hurt(DamageSource.FALLING_BLOCK, damage);
            return bl;
        }
        finally {
            if (isAnvil) {
                ((DamageSourceBridge)source).bridge$setAnvilSource();
            } else {
                ((DamageSourceBridge)source).bridge$setFallingBlockSource();
            }
        }
    }
}

