/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.entity.projectile;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.block.entity.TheEndGatewayBlockEntity;
import net.minecraft.world.phys.HitResult;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.common.bridge.world.level.LevelBridge;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.mixin.core.world.entity.projectile.ProjectileMixin;

@Mixin(value={ThrowableProjectile.class})
public abstract class ThrowableProjectileMixin
extends ProjectileMixin {
    @Redirect(method={"tick()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/projectile/ThrowableProjectile;onHit(Lnet/minecraft/world/phys/HitResult;)V"))
    private void impl$handleProjectileImpact(ThrowableProjectile projectile, HitResult movingObjectPosition) {
        if (((LevelBridge)this.level).bridge$isFake() || movingObjectPosition.getType() == HitResult.Type.MISS) {
            this.shadow$onHit(movingObjectPosition);
            return;
        }
        if (SpongeCommonEventFactory.handleCollideImpactEvent((Entity)projectile, this.impl$getProjectileSource(), movingObjectPosition)) {
            this.shadow$remove();
        } else {
            this.shadow$onHit(movingObjectPosition);
        }
    }

    @Redirect(method={"tick"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/block/entity/TheEndGatewayBlockEntity;teleportEntity(Lnet/minecraft/world/entity/Entity;)V"))
    private void impl$createCauseFrameForGatewayTeleport(TheEndGatewayBlockEntity endGatewayTileEntity, Entity entityIn) {
        if (this.shadow$getCommandSenderWorld().isClientSide) {
            return;
        }
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            frame.pushCause(endGatewayTileEntity);
            frame.pushCause(entityIn);
            endGatewayTileEntity.teleportEntity(entityIn);
        }
    }
}

