/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.level;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.chunk.LevelChunk;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.accessor.world.level.NaturalSpawner_SpawnStateAccessor;
import org.spongepowered.common.bridge.world.level.NaturalSpawner_SpawnStateBridge;
import org.spongepowered.common.bridge.world.level.storage.PrimaryLevelDataBridge;
import org.spongepowered.common.config.inheritable.SpawnerCategory;
import org.spongepowered.common.config.inheritable.WorldConfig;

@Mixin(value={NaturalSpawner.class})
public abstract class NaturalSpawnerMixin {
    @Shadow
    @Final
    private static MobCategory[] SPAWNING_CATEGORIES;

    @Shadow
    public static void spawnCategoryForChunk(MobCategory p_234967_0_, ServerLevel p_234967_1_, LevelChunk p_234967_2_, NaturalSpawner.SpawnPredicate p_234967_3_, NaturalSpawner.AfterSpawnCallback p_234967_4_) {
    }

    @Overwrite
    public static void spawnForChunk(ServerLevel world, LevelChunk chunk, NaturalSpawner.SpawnState manager, boolean spawnFriendlies, boolean spawnEnemies, boolean doMobSpawning) {
        world.getProfiler().push("spawner");
        for (MobCategory entityclassification : SPAWNING_CATEGORIES) {
            if (!spawnFriendlies && entityclassification.isFriendly() || !spawnEnemies && !entityclassification.isFriendly() || !doMobSpawning && entityclassification.isPersistent() || !NaturalSpawnerMixin.impl$canSpawnInLevel(manager, entityclassification, world)) continue;
            NaturalSpawnerMixin.spawnCategoryForChunk(entityclassification, world, chunk, (p_234969_1_, p_234969_2_, p_234969_3_) -> ((NaturalSpawner_SpawnStateAccessor)manager).invoker$canSpawn(p_234969_1_, p_234969_2_, p_234969_3_), (p_234970_1_, p_234970_2_) -> ((NaturalSpawner_SpawnStateAccessor)manager).invoker$afterSpawn(p_234970_1_, p_234970_2_));
        }
        world.getProfiler().pop();
    }

    private static boolean impl$canSpawnInLevel(NaturalSpawner.SpawnState manager, MobCategory classification, ServerLevel level) {
        int tick = NaturalSpawnerMixin.impl$getSpawningTickRate(classification, level);
        if (tick == -1) {
            return ((NaturalSpawner_SpawnStateAccessor)manager).invoker$canSpawnForCategory(classification);
        }
        if (tick == 0) {
            return false;
        }
        return level.getGameTime() % (long)tick == 0L && ((NaturalSpawner_SpawnStateBridge)manager).bridge$canSpawnForCategoryInWorld(classification, level);
    }

    private static int impl$getSpawningTickRate(MobCategory classification, ServerLevel world) {
        SpawnerCategory.TickRatesSubCategory tickRates = ((WorldConfig)((PrimaryLevelDataBridge)world.getLevelData()).bridge$configAdapter().get()).spawner.tickRates;
        switch (classification) {
            case MONSTER: {
                return tickRates.monster;
            }
            case CREATURE: {
                return tickRates.creature;
            }
            case AMBIENT: {
                return tickRates.ambient;
            }
            case WATER_CREATURE: {
                return tickRates.aquaticCreature;
            }
            case WATER_AMBIENT: {
                return tickRates.aquaticAmbient;
            }
        }
        return -1;
    }
}

