/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.level.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.MappedRegistry;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.NoteBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.Material;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.data.type.InstrumentType;
import org.spongepowered.api.data.type.NotePitch;
import org.spongepowered.api.event.sound.PlaySoundEvent;
import org.spongepowered.api.registry.RegistryTypes;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.mixin.core.block.BlockMixin;

@Mixin(value={NoteBlock.class})
public abstract class NoteBlockMixin
extends BlockMixin {
    @Inject(method={"triggerEvent"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;playSound(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/core/BlockPos;Lnet/minecraft/sounds/SoundEvent;Lnet/minecraft/sounds/SoundSource;FF)V")}, cancellable=true)
    private void impl$throwNoteBlockSoundEvent(BlockState state, Level worldIn, BlockPos pos, int id, int param, CallbackInfoReturnable<Boolean> callbackInfo) {
        if (!ShouldFire.PLAY_SOUND_EVENT_NOTE_BLOCK) {
            return;
        }
        if (worldIn.getBlockState(pos.above()).getMaterial() != Material.AIR) {
            return;
        }
        InstrumentType instrumentType = ((ServerWorld)worldIn).block(pos.getX(), pos.getY() - 1, pos.getZ()).get(Keys.REPRESENTED_INSTRUMENT).orElse(null);
        if (instrumentType == null) {
            return;
        }
        float pitch = (float)Math.pow(2.0, (double)(param - 12) / 12.0);
        MappedRegistry registry = (MappedRegistry)Sponge.game().registry(RegistryTypes.NOTE_PITCH);
        PlaySoundEvent.NoteBlock event = SpongeCommonEventFactory.callPlaySoundNoteBlockEvent(PhaseTracker.getCauseStackManager().currentCause(), (ServerWorld)worldIn, pos, NoteBlockInstrument.byState((BlockState)state).getSoundEvent(), instrumentType, (NotePitch)registry.byId(param), Float.valueOf(pitch));
        if (event.isCancelled()) {
            callbackInfo.setReturnValue((Object)true);
        }
    }
}

